/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.config.Config;
import io.helidon.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

class ConfigKeyImpl
implements Config.Key {
    private final String name;
    private final ConfigKeyImpl parent;
    private final List<String> path;
    private final String fullKey;

    private ConfigKeyImpl(ConfigKeyImpl parent, String name) {
        Objects.requireNonNull(name, "name is mandatory");
        if (name.contains(".")) {
            throw new IllegalArgumentException("Illegal key token format. Dot character ('.') is not supported.");
        }
        this.parent = parent;
        ArrayList<String> path = new ArrayList<String>();
        StringBuilder fullSB = new StringBuilder();
        if (parent != null) {
            path.addAll(parent.path);
            fullSB.append(parent.fullKey);
        }
        if (!name.isEmpty()) {
            if (fullSB.length() > 0) {
                fullSB.append(".");
            }
            path.add(name);
            fullSB.append(name);
        }
        this.name = Config.Key.unescapeName(name);
        this.path = Collections.unmodifiableList(path);
        this.fullKey = fullSB.toString();
    }

    @Override
    public ConfigKeyImpl parent() {
        if (this.isRoot()) {
            throw new IllegalStateException("Attempting to get parent of a root node. Guard by isRoot instead");
        }
        return this.parent;
    }

    public boolean isRoot() {
        return null == this.parent;
    }

    static ConfigKeyImpl of() {
        return new ConfigKeyImpl(null, "");
    }

    static ConfigKeyImpl of(String key) {
        return ConfigKeyImpl.of().child(key);
    }

    ConfigKeyImpl child(String key) {
        return this.child(Arrays.asList(key.split("\\.")));
    }

    @Override
    public ConfigKeyImpl child(Config.Key key) {
        List<String> path;
        if (key instanceof ConfigKeyImpl) {
            path = ((ConfigKeyImpl)key).path;
        } else {
            path = new LinkedList<String>();
            while (!key.isRoot()) {
                path.add(0, key.name());
                key = key.parent();
            }
        }
        return this.child(path);
    }

    private ConfigKeyImpl child(List<String> path) {
        ConfigKeyImpl result = this;
        for (String name : path) {
            if (name.isEmpty()) continue;
            result = new ConfigKeyImpl(result, name);
        }
        return result;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.fullKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Config.Key)) {
            return false;
        }
        Config.Key key = (Config.Key)o;
        return Objects.equals(this.name(), key.name()) && Objects.equals(this.isRoot(), key.isRoot()) && (this.isRoot() || Objects.equals(this.parent(), key.parent()));
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent);
    }

    public int compareTo(Config.Key that) {
        return this.toString().compareTo(that.toString());
    }
}

