/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigException;
import io.helidon.common.config.GlobalConfig;
import io.helidon.config.BuilderImpl;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.MetaConfig;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigMapper;
import io.helidon.config.spi.ConfigMapperProvider;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.MergingStrategy;
import io.helidon.config.spi.OverrideSource;
import io.helidon.service.registry.Service;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Service.Contract
public interface Config
extends io.helidon.common.config.Config {
    public static final GenericType<Config> GENERIC_TYPE = GenericType.create(Config.class);

    public static Config empty() {
        return BuilderImpl.EmptyConfigHolder.EMPTY;
    }

    public static Config create() {
        return Config.builder().metaConfig().build();
    }

    @SafeVarargs
    public static Config create(Supplier<? extends ConfigSource> ... configSources) {
        return Config.builder(configSources).build();
    }

    @SafeVarargs
    public static Builder builder(Supplier<? extends ConfigSource> ... configSources) {
        return Config.builder().sources(List.of(configSources));
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @SafeVarargs
    public static Config just(Supplier<? extends ConfigSource> ... configSources) {
        return Config.builder(configSources).disableEnvironmentVariablesSource().disableSystemPropertiesSource().build();
    }

    public static Config global() {
        if (GlobalConfig.configured()) {
            io.helidon.common.config.Config global = GlobalConfig.config();
            if (global instanceof Config) {
                Config cfg = (Config)global;
                return cfg;
            }
            return BuilderImpl.GlobalConfigHolder.get();
        }
        Config config = Config.create();
        GlobalConfig.config(() -> config, (boolean)true);
        return config;
    }

    public static void global(Config config) {
        GlobalConfig.config(() -> config, (boolean)true);
        BuilderImpl.GlobalConfigHolder.set(config);
    }

    default public Context context() {
        return new Context(){

            @Override
            public Instant timestamp() {
                return Config.this.timestamp();
            }

            @Override
            public Config last() {
                return Config.this;
            }

            @Override
            public Config reload() {
                return Config.this;
            }
        };
    }

    public Instant timestamp();

    public Key key();

    default public String name() {
        return this.key().name();
    }

    default public Config get(String key) {
        Objects.requireNonNull(key, "Key argument is null.");
        return this.get(ConfigKeyImpl.of(key));
    }

    public Config root();

    public Config get(Key var1);

    public Config detach();

    public Type type();

    default public boolean exists() {
        return this.type().exists();
    }

    default public boolean isLeaf() {
        return this.type().isLeaf();
    }

    default public boolean isObject() {
        return Type.OBJECT == this.type();
    }

    default public boolean isList() {
        return Type.LIST == this.type();
    }

    public boolean hasValue();

    default public void ifExists(Consumer<Config> action) {
        this.asNode().ifPresent(action);
    }

    default public Stream<Config> traverse() {
        return this.traverse(node -> true);
    }

    public Stream<Config> traverse(Predicate<Config> var1);

    public <T> T convert(Class<T> var1, String var2) throws ConfigMappingException;

    public ConfigMapper mapper();

    public <T> ConfigValue<T> as(GenericType<T> var1);

    public <T> ConfigValue<T> as(Class<T> var1);

    public <T> ConfigValue<T> as(Function<Config, T> var1);

    default public <T> io.helidon.common.config.ConfigValue<T> map(Function<io.helidon.common.config.Config, T> mapper) {
        return this.as(mapper::apply);
    }

    default public ConfigValue<Boolean> asBoolean() {
        return this.as(Boolean.class);
    }

    default public ConfigValue<String> asString() {
        return this.as(String.class);
    }

    default public ConfigValue<Integer> asInt() {
        return this.as(Integer.class);
    }

    default public ConfigValue<Long> asLong() {
        return this.as(Long.class);
    }

    default public ConfigValue<Double> asDouble() {
        return this.as(Double.class);
    }

    public <T> ConfigValue<List<T>> asList(Class<T> var1) throws ConfigMappingException;

    public <T> ConfigValue<List<T>> asList(Function<Config, T> var1) throws ConfigMappingException;

    default public <T> io.helidon.common.config.ConfigValue<List<T>> mapList(Function<io.helidon.common.config.Config, T> mapper) throws ConfigException {
        return this.asList(mapper::apply);
    }

    /*
     * Exception decompiling
     */
    default public ConfigValue<Config> asNode() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ConfigValue<List<Config>> asNodeList() throws ConfigMappingException;

    public ConfigValue<Map<String, String>> asMap() throws MissingValueException;

    default public void onChange(Consumer<Config> onChangeConsumer) {
    }

    public static interface Builder
    extends io.helidon.common.Builder<Builder, Config> {
        public Builder sources(List<Supplier<? extends ConfigSource>> var1);

        public Builder addSource(ConfigSource var1);

        public Builder mergingStrategy(MergingStrategy var1);

        default public Builder addSource(Supplier<? extends ConfigSource> source) {
            return this.addSource(source.get());
        }

        default public Builder sources(Supplier<? extends ConfigSource> configSource) {
            this.sources(List.of(configSource));
            return this;
        }

        default public Builder sources(Supplier<? extends ConfigSource> configSource, Supplier<? extends ConfigSource> configSource2) {
            this.sources(List.of(configSource, configSource2));
            return this;
        }

        default public Builder sources(Supplier<? extends ConfigSource> configSource, Supplier<? extends ConfigSource> configSource2, Supplier<? extends ConfigSource> configSource3) {
            this.sources(List.of(configSource, configSource2, configSource3));
            return this;
        }

        public Builder overrides(Supplier<? extends OverrideSource> var1);

        public Builder disableKeyResolving();

        public Builder failOnMissingKeyReference(boolean var1);

        public Builder disableValueResolving();

        public Builder failOnMissingValueReference(boolean var1);

        public Builder disableEnvironmentVariablesSource();

        public Builder disableSystemPropertiesSource();

        public <T> Builder addMapper(Class<T> var1, Function<Config, T> var2);

        public <T> Builder addMapper(GenericType<T> var1, Function<Config, T> var2);

        public <T> Builder addStringMapper(Class<T> var1, Function<String, T> var2);

        public Builder addMapper(ConfigMapperProvider var1);

        public Builder disableMapperServices();

        public Builder addParser(ConfigParser var1);

        public Builder disableParserServices();

        public Builder addFilter(ConfigFilter var1);

        public Builder addFilter(Function<Config, ConfigFilter> var1);

        public Builder addFilter(Supplier<Function<Config, ConfigFilter>> var1);

        public Builder disableFilterServices();

        public Builder disableCaching();

        public Builder changesExecutor(Executor var1);

        public Config build();

        default public Builder metaConfig() {
            MetaConfig.metaConfig().ifPresent(this::config);
            return this;
        }

        public Builder config(Config var1);
    }

    public static interface Key
    extends Config.Key {
        public Key parent();

        public Key child(Config.Key var1);

        public static Key create(String key) {
            return ConfigKeyImpl.of(key);
        }

        public static String escapeName(String name) {
            char[] chars;
            if (!name.contains("~") && !name.contains(".")) {
                return name;
            }
            StringBuilder sb = new StringBuilder();
            for (char ch : chars = name.toCharArray()) {
                if (ch == '~') {
                    sb.append("~0");
                    continue;
                }
                if (ch == '.') {
                    sb.append("~1");
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        public static String unescapeName(String escapedName) {
            return escapedName.replaceAll("~1", ".").replaceAll("~0", "~");
        }
    }

    public static enum Type {
        OBJECT(true, false),
        LIST(true, false),
        VALUE(true, true),
        MISSING(false, false);

        private final boolean exists;
        private final boolean isLeaf;

        private Type(boolean exists, boolean isLeaf) {
            this.exists = exists;
            this.isLeaf = isLeaf;
        }

        public boolean exists() {
            return this.exists;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }
    }

    public static interface Context {
        public Instant timestamp();

        public Config last();

        public Config reload();
    }
}

