/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.AbstractConfigSource;
import io.helidon.config.AbstractConfigSourceBuilder;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.FileSourceHelper;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ParsableSource;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.WatchableSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;

public class FileConfigSource
extends AbstractConfigSource
implements WatchableSource<Path>,
ParsableSource,
PollableSource<byte[]> {
    private static final Logger LOGGER = Logger.getLogger(FileConfigSource.class.getName());
    private static final String PATH_KEY = "path";
    private final Path filePath;

    FileConfigSource(Builder builder) {
        super(builder);
        this.filePath = builder.path;
    }

    public static FileConfigSource create(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return FileConfigSource.builder().config(metaConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String uid() {
        return this.filePath.toString();
    }

    @Override
    public boolean isModified(byte[] stamp) {
        return FileSourceHelper.isModified(this.filePath, stamp);
    }

    @Override
    public Path target() {
        return this.filePath;
    }

    @Override
    public Optional<ConfigParser.Content> load() throws ConfigException {
        LOGGER.fine(() -> String.format("Getting content from '%s'", this.filePath));
        Optional<FileSourceHelper.DataAndDigest> dataAndDigest = FileSourceHelper.readDataAndDigest(this.filePath);
        if (dataAndDigest.isEmpty()) {
            return Optional.empty();
        }
        FileSourceHelper.DataAndDigest dad = dataAndDigest.get();
        ByteArrayInputStream dataStream = new ByteArrayInputStream(dad.data());
        ConfigParser.Content.Builder builder = ((ConfigParser.Content.Builder)ConfigParser.Content.builder().stamp(dad.digest())).data(dataStream);
        MediaTypes.detectType((Path)this.filePath).ifPresent(builder::mediaType);
        return Optional.of(builder.build());
    }

    @Override
    public Function<String, Optional<InputStream>> relativeResolver() {
        return it -> {
            Path path = this.filePath.getParent().resolve((String)it);
            if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path) && !Files.isDirectory(path, new LinkOption[0])) {
                try {
                    return Optional.of(Files.newInputStream(path, new OpenOption[0]));
                }
                catch (IOException e) {
                    throw new ConfigException("Failed to read configuration from path: " + path.toAbsolutePath(), e);
                }
            }
            return Optional.empty();
        };
    }

    @Override
    public Optional<ConfigParser> parser() {
        return super.parser();
    }

    @Override
    public Optional<String> mediaType() {
        return super.mediaType();
    }

    @Override
    public Optional<PollingStrategy> pollingStrategy() {
        return super.pollingStrategy();
    }

    @Override
    public Optional<ChangeWatcher<Object>> changeWatcher() {
        return super.changeWatcher();
    }

    @Override
    public boolean exists() {
        return Files.exists(this.filePath, new LinkOption[0]);
    }

    public static final class Builder
    extends AbstractConfigSourceBuilder<Builder, Path>
    implements PollableSource.Builder<Builder>,
    WatchableSource.Builder<Builder, Path>,
    ParsableSource.Builder<Builder>,
    io.helidon.common.Builder<Builder, FileConfigSource> {
        private Path path;

        private Builder() {
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        @Override
        public Builder config(Config metaConfig) {
            metaConfig.get(FileConfigSource.PATH_KEY).as(Path.class).ifPresent(this::path);
            return (Builder)super.config(metaConfig);
        }

        @Override
        public Builder parser(ConfigParser parser) {
            return (Builder)super.parser(parser);
        }

        @Override
        public Builder mediaType(String mediaType) {
            return (Builder)super.mediaType(mediaType);
        }

        @Override
        public Builder changeWatcher(ChangeWatcher<Path> changeWatcher) {
            return (Builder)super.changeWatcher(changeWatcher);
        }

        @Override
        public Builder pollingStrategy(PollingStrategy pollingStrategy) {
            return (Builder)super.pollingStrategy(pollingStrategy);
        }

        public FileConfigSource build() {
            if (null == this.path) {
                throw new IllegalArgumentException("File path cannot be null");
            }
            return new FileConfigSource(this);
        }
    }
}

