/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.GenericType;
import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.ConfigValues;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

abstract class ConfigExistingImpl<N extends ConfigNode>
extends AbstractConfigImpl {
    private final N node;
    private final ConfigMapperManager mapperManager;
    private final ConfigFilter filter;

    ConfigExistingImpl(Config.Type type, ConfigKeyImpl prefix, ConfigKeyImpl key, N node, ConfigFilter filter, ConfigFactory factory, ConfigMapperManager mapperManager) {
        super(type, prefix, key, factory, mapperManager);
        this.filter = filter;
        Objects.requireNonNull(node, "node argument is null.");
        Objects.requireNonNull(mapperManager, "mapperManager argument is null.");
        this.node = node;
        this.mapperManager = mapperManager;
    }

    @Override
    public final Optional<String> value() throws ConfigMappingException {
        return this.node.value().map(it -> this.filter.apply(this.realKey(), (String)it));
    }

    @Override
    public boolean hasValue() {
        return this.node().value().isPresent();
    }

    @Override
    public <T> ConfigValue<T> as(GenericType<T> genericType) {
        return ConfigValues.create((Config)this, genericType, this.mapperManager);
    }

    @Override
    public <T> ConfigValue<T> as(Class<T> type) {
        return ConfigValues.create((Config)this, type, this.mapperManager);
    }

    @Override
    public <T> ConfigValue<T> as(Function<Config, T> mapper) {
        return ConfigValues.create(this, mapper);
    }

    @Override
    public ConfigValue<Map<String, String>> asMap() {
        return ConfigValues.createMap(this, this.mapperManager);
    }

    protected final N node() {
        return this.node;
    }
}

