/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractConfigSourceBuilder;
import io.helidon.config.AbstractSource;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ListNodeBuilderImpl;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractConfigSource
extends AbstractSource
implements ConfigSource {
    private final Optional<String> mediaType;
    private final Optional<ConfigParser> parser;
    private final Optional<Function<Config.Key, Optional<String>>> mediaTypeMapping;
    private final Optional<Function<Config.Key, Optional<ConfigParser>>> parserMapping;
    private final boolean mediaMappingSupported;

    protected AbstractConfigSource(AbstractConfigSourceBuilder<?, ?> builder) {
        super(builder);
        this.mediaType = builder.mediaType();
        this.parser = builder.parser();
        this.mediaTypeMapping = builder.mediaTypeMapping();
        this.parserMapping = builder.parserMapping();
        this.mediaMappingSupported = this.mediaTypeMapping.isPresent() || this.parserMapping.isPresent();
    }

    protected Optional<String> mediaType() {
        return this.mediaType;
    }

    protected Optional<ConfigParser> parser() {
        return this.parser;
    }

    public String toString() {
        return this.description();
    }

    ConfigNode.ObjectNode processNodeMapping(Function<String, Optional<ConfigParser>> mediaToParser, ConfigKeyImpl configKey, ConfigNode.ObjectNode loaded) {
        if (!this.mediaMappingSupported) {
            return loaded;
        }
        return this.processObject(mediaToParser, configKey, loaded);
    }

    private ConfigNode.ObjectNode processObject(Function<String, Optional<ConfigParser>> mediaToParser, ConfigKeyImpl key, ConfigNode.ObjectNode objectNode) {
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        objectNode.forEach((name, node) -> builder.addNode((String)name, this.processNode(mediaToParser, key.child((String)name), (ConfigNode)node)));
        return builder.build();
    }

    private ConfigNode processNode(Function<String, Optional<ConfigParser>> mediaToParser, ConfigKeyImpl key, ConfigNode node) {
        switch (node.nodeType()) {
            case OBJECT: {
                return this.processObject(mediaToParser, key, (ConfigNode.ObjectNode)node);
            }
            case LIST: {
                return this.processList(mediaToParser, key, (ConfigNode.ListNode)node);
            }
            case VALUE: {
                return this.processValue(mediaToParser, key, (ConfigNode.ValueNode)node);
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }

    private ConfigNode.ListNode processList(Function<String, Optional<ConfigParser>> mediaToParser, ConfigKeyImpl key, ConfigNode.ListNode listNode) {
        ListNodeBuilderImpl builder = (ListNodeBuilderImpl)ConfigNode.ListNode.builder();
        for (int i = 0; i < listNode.size(); ++i) {
            builder.addNode(this.processNode(mediaToParser, key.child(Integer.toString(i)), (ConfigNode)listNode.get(i)));
        }
        return builder.build();
    }

    private ConfigNode processValue(Function<String, Optional<ConfigParser>> mediaToParser, Config.Key key, ConfigNode.ValueNode valueNode) {
        Optional<ConfigParser> parser = this.findParserForKey(mediaToParser, key);
        if (parser.isEmpty()) {
            return valueNode;
        }
        ConfigParser found = parser.get();
        return found.parse(ConfigParser.Content.builder().data(this.toStream(valueNode.get())).charset(StandardCharsets.UTF_8).build(), it -> Optional.empty());
    }

    private InputStream toStream(String string) {
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    private Optional<ConfigParser> findParserForKey(Function<String, Optional<ConfigParser>> mediaToParser, Config.Key key) {
        Optional<ConfigParser> parser = this.parserMapping.flatMap(it -> (Optional)it.apply(key));
        if (parser.isPresent()) {
            return parser;
        }
        Optional maybeMedia = this.mediaTypeMapping.flatMap(it -> (Optional)it.apply(key));
        if (maybeMedia.isEmpty()) {
            return Optional.empty();
        }
        String mediaType = (String)maybeMedia.get();
        return Optional.of(mediaToParser.apply(mediaType).orElseThrow(() -> new ConfigException("Cannot find parser for media type " + mediaType + " for key " + key + " in config source " + this.description())));
    }
}

