/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.GenericType;
import io.helidon.common.Prioritized;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.common.serviceloader.Priorities;
import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigFilters;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigSourceRuntime;
import io.helidon.config.ConfigSourceRuntimeImpl;
import io.helidon.config.ConfigSources;
import io.helidon.config.ConfigSourcesRuntime;
import io.helidon.config.ConfigThreadFactory;
import io.helidon.config.EnvironmentVariableAliases;
import io.helidon.config.MetaConfig;
import io.helidon.config.OverrideSourceRuntime;
import io.helidon.config.OverrideSources;
import io.helidon.config.ProviderImpl;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigMapper;
import io.helidon.config.spi.ConfigMapperProvider;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.MergingStrategy;
import io.helidon.config.spi.OverrideSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

class BuilderImpl
implements Config.Builder {
    private final List<ConfigSource> sources = new LinkedList<ConfigSource>();
    private MergingStrategy mergingStrategy = MergingStrategy.fallback();
    private boolean hasSystemPropertiesSource;
    private boolean hasEnvVarSource;
    private final List<PrioritizedMapperProvider> prioritizedMappers = new ArrayList<PrioritizedMapperProvider>();
    private final ConfigMapperManager.MapperProviders mapperProviders;
    private boolean mapperServicesEnabled = true;
    private final List<ConfigParser> parsers;
    private boolean parserServicesEnabled = true;
    private final List<Function<Config, ConfigFilter>> filterProviders;
    private boolean filterServicesEnabled = true;
    private Executor changesExecutor;
    private OverrideSource overrideSource = OverrideSources.empty();
    private boolean cachingEnabled = true;
    private boolean keyResolving = true;
    private boolean valueResolving = true;
    private boolean systemPropertiesSourceEnabled = true;
    private boolean environmentVariablesSourceEnabled = true;
    private boolean envVarAliasGeneratorEnabled = false;

    BuilderImpl() {
        this.mapperProviders = ConfigMapperManager.MapperProviders.create();
        this.parsers = new ArrayList<ConfigParser>();
        this.filterProviders = new ArrayList<Function<Config, ConfigFilter>>();
    }

    @Override
    public Config.Builder sources(List<Supplier<? extends ConfigSource>> sourceSuppliers) {
        this.sources.clear();
        sourceSuppliers.stream().map(Supplier::get).forEach(this::addSource);
        return this;
    }

    @Override
    public Config.Builder addSource(ConfigSource source) {
        this.sources.add(source);
        if (source instanceof ConfigSources.EnvironmentVariablesConfigSource) {
            this.envVarAliasGeneratorEnabled = true;
            this.hasEnvVarSource = true;
        } else if (source instanceof ConfigSources.SystemPropertiesConfigSource) {
            this.hasSystemPropertiesSource = true;
        }
        return this;
    }

    @Override
    public Config.Builder overrides(Supplier<? extends OverrideSource> overridingSource) {
        this.overrideSource = overridingSource.get();
        return this;
    }

    @Override
    public Config.Builder disableMapperServices() {
        this.mapperServicesEnabled = false;
        return this;
    }

    @Override
    public <T> Config.Builder addStringMapper(Class<T> type, Function<String, T> mapper) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(mapper);
        if (String.class.equals(type)) {
            return this;
        }
        this.addMapper(type, (Config config) -> mapper.apply(config.asString().get()));
        return this;
    }

    @Override
    public <T> Config.Builder addMapper(Class<T> type, Function<Config, T> mapper) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(mapper);
        this.addMapper(() -> Map.of(type, mapper));
        return this;
    }

    @Override
    public <T> Config.Builder addMapper(final GenericType<T> type, final Function<Config, T> mappingFunction) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(mappingFunction);
        this.addMapper(new ConfigMapperProvider(){

            @Override
            public Map<Class<?>, Function<Config, ?>> mappers() {
                return Map.of();
            }

            @Override
            public Map<GenericType<?>, BiFunction<Config, ConfigMapper, ?>> genericTypeMappers() {
                return Map.of(type, (config, aMapper) -> mappingFunction.apply(config));
            }
        });
        return this;
    }

    @Override
    public Config.Builder addMapper(ConfigMapperProvider mapperProvider) {
        Objects.requireNonNull(mapperProvider);
        this.mapperProviders.add(mapperProvider);
        return this;
    }

    @Override
    public Config.Builder addParser(ConfigParser configParser) {
        Objects.requireNonNull(configParser);
        this.parsers.add(configParser);
        return this;
    }

    @Override
    public Config.Builder disableParserServices() {
        this.parserServicesEnabled = false;
        return this;
    }

    @Override
    public Config.Builder addFilter(ConfigFilter configFilter) {
        Objects.requireNonNull(configFilter);
        this.filterProviders.add(config -> configFilter);
        return this;
    }

    @Override
    public Config.Builder addFilter(Function<Config, ConfigFilter> configFilterProvider) {
        Objects.requireNonNull(configFilterProvider);
        this.filterProviders.add(configFilterProvider);
        return this;
    }

    @Override
    public Config.Builder addFilter(Supplier<Function<Config, ConfigFilter>> configFilterSupplier) {
        Objects.requireNonNull(configFilterSupplier);
        this.filterProviders.add(configFilterSupplier.get());
        return this;
    }

    @Override
    public Config.Builder disableFilterServices() {
        this.filterServicesEnabled = false;
        return this;
    }

    @Override
    public Config.Builder disableCaching() {
        this.cachingEnabled = false;
        return this;
    }

    @Override
    public Config.Builder changesExecutor(Executor changesExecutor) {
        Objects.requireNonNull(changesExecutor);
        this.changesExecutor = changesExecutor;
        return this;
    }

    @Override
    public Config.Builder disableKeyResolving() {
        this.keyResolving = false;
        return this;
    }

    @Override
    public Config.Builder disableValueResolving() {
        this.valueResolving = false;
        return this;
    }

    @Override
    public Config.Builder disableEnvironmentVariablesSource() {
        this.environmentVariablesSourceEnabled = false;
        return this;
    }

    @Override
    public Config.Builder disableSystemPropertiesSource() {
        this.systemPropertiesSourceEnabled = false;
        return this;
    }

    @Override
    public AbstractConfigImpl build() {
        if (this.valueResolving) {
            this.addFilter(ConfigFilters.valueResolving());
        }
        if (null == this.changesExecutor) {
            this.changesExecutor = Executors.newCachedThreadPool(new ConfigThreadFactory("config-changes"));
        }
        ConfigMapperManager configMapperManager = BuilderImpl.buildMappers(this.prioritizedMappers, this.mapperProviders, this.mapperServicesEnabled);
        if (this.filterServicesEnabled) {
            this.addAutoLoadedFilters();
        }
        ConfigContextImpl context = new ConfigContextImpl(this.changesExecutor, BuilderImpl.buildParsers(this.parserServicesEnabled, this.parsers));
        ConfigSourcesRuntime configSources = this.buildConfigSources(context);
        Function<String, List<String>> aliasGenerator = this.envVarAliasGeneratorEnabled ? EnvironmentVariableAliases::aliasesOf : null;
        return this.createProvider(configMapperManager, configSources, new OverrideSourceRuntime(this.overrideSource), this.filterProviders, this.cachingEnabled, this.changesExecutor, this.keyResolving, aliasGenerator).newConfig();
    }

    private static void addBuiltInMapperServices(List<PrioritizedMapperProvider> prioritizedMappers) {
        prioritizedMappers.add(new HelidonMapperWrapper(new InternalMapperProvider(ConfigMappers.essentialMappers(), "essential"), 200));
        prioritizedMappers.add(new HelidonMapperWrapper(new InternalMapperProvider(ConfigMappers.builtInMappers(), "built-in"), 200));
    }

    @Override
    public Config.Builder config(Config metaConfig) {
        metaConfig.get("caching.enabled").asBoolean().ifPresent(this::cachingEnabled);
        metaConfig.get("key-resolving.enabled").asBoolean().ifPresent(this::keyResolvingEnabled);
        metaConfig.get("parsers.enabled").asBoolean().ifPresent(this::parserServicesEnabled);
        metaConfig.get("mappers.enabled").asBoolean().ifPresent(this::mapperServicesEnabled);
        this.disableSystemPropertiesSource();
        this.disableEnvironmentVariablesSource();
        LinkedList sourceList = new LinkedList();
        metaConfig.get("sources").asNodeList().ifPresent(list -> list.forEach(it -> sourceList.addAll(MetaConfig.configSource(it))));
        sourceList.forEach(this::addSource);
        sourceList.clear();
        Config overrideConfig = metaConfig.get("override-source");
        if (overrideConfig.exists()) {
            this.overrides(() -> MetaConfig.overrideSource(overrideConfig));
        }
        return this;
    }

    @Override
    public Config.Builder mergingStrategy(MergingStrategy strategy) {
        this.mergingStrategy = strategy;
        return this;
    }

    private void cachingEnabled(boolean enabled) {
        this.cachingEnabled = enabled;
    }

    private void mapperServicesEnabled(Boolean aBoolean) {
        this.mapperServicesEnabled = aBoolean;
    }

    private void parserServicesEnabled(Boolean aBoolean) {
        this.parserServicesEnabled = aBoolean;
    }

    private void keyResolvingEnabled(Boolean aBoolean) {
        this.keyResolving = aBoolean;
    }

    private ConfigSourcesRuntime buildConfigSources(ConfigContextImpl context) {
        boolean nothingConfigured;
        LinkedList<ConfigSourceRuntimeImpl> targetSources = new LinkedList<ConfigSourceRuntimeImpl>();
        if (this.systemPropertiesSourceEnabled && !this.hasSystemPropertiesSource) {
            this.hasSystemPropertiesSource = true;
            targetSources.add(context.sourceRuntimeBase(ConfigSources.systemProperties().build()));
        }
        if (this.environmentVariablesSourceEnabled && !this.hasEnvVarSource) {
            this.hasEnvVarSource = true;
            targetSources.add(context.sourceRuntimeBase(ConfigSources.environmentVariables()));
        }
        if (this.hasEnvVarSource) {
            this.envVarAliasGeneratorEnabled = true;
        }
        if (nothingConfigured = this.sources.isEmpty()) {
            MetaConfig.configSources(mediaType -> context.findParser((String)mediaType).isPresent(), context.supportedSuffixes()).stream().map(x$0 -> context.sourceRuntimeBase((ConfigSource)x$0)).forEach(targetSources::add);
        } else {
            this.sources.stream().map(x$0 -> context.sourceRuntimeBase((ConfigSource)x$0)).forEach(targetSources::add);
        }
        return new ConfigSourcesRuntime(targetSources, this.mergingStrategy);
    }

    ProviderImpl createProvider(ConfigMapperManager configMapperManager, ConfigSourcesRuntime targetConfigSource, OverrideSourceRuntime overrideSource, List<Function<Config, ConfigFilter>> filterProviders, boolean cachingEnabled, Executor changesExecutor, boolean keyResolving, Function<String, List<String>> aliasGenerator) {
        return new ProviderImpl(configMapperManager, targetConfigSource, overrideSource, filterProviders, cachingEnabled, changesExecutor, keyResolving, aliasGenerator);
    }

    static List<ConfigParser> buildParsers(boolean servicesEnabled, List<ConfigParser> userDefinedParsers) {
        LinkedList<ConfigParser> parsers = new LinkedList<ConfigParser>(userDefinedParsers);
        if (servicesEnabled) {
            parsers.addAll(BuilderImpl.loadParserServices());
        }
        return parsers;
    }

    static ConfigMapperManager buildMappers(ConfigMapperManager.MapperProviders userDefinedProviders) {
        return BuilderImpl.buildMappers(new ArrayList<PrioritizedMapperProvider>(), userDefinedProviders, false);
    }

    static ConfigMapperManager buildMappers(List<PrioritizedMapperProvider> prioritizedMappers, ConfigMapperManager.MapperProviders userDefinedProviders, boolean mapperServicesEnabled) {
        if (mapperServicesEnabled) {
            BuilderImpl.loadMapperServices(prioritizedMappers);
        }
        BuilderImpl.addBuiltInMapperServices(prioritizedMappers);
        Priorities.sort(prioritizedMappers);
        Collections.reverse(prioritizedMappers);
        ConfigMapperManager.MapperProviders providers = ConfigMapperManager.MapperProviders.create();
        prioritizedMappers.forEach(providers::add);
        providers.addAll(userDefinedProviders);
        return new ConfigMapperManager(providers);
    }

    private static void loadMapperServices(List<PrioritizedMapperProvider> providers) {
        HelidonServiceLoader.builder(ServiceLoader.load(ConfigMapperProvider.class)).defaultPriority(100).build().forEach(mapper -> providers.add(new HelidonMapperWrapper((ConfigMapperProvider)mapper, Priorities.find((Object)mapper, (int)100))));
    }

    private static List<ConfigParser> loadParserServices() {
        return HelidonServiceLoader.builder(ServiceLoader.load(ConfigParser.class)).defaultPriority(100).build().asList();
    }

    private void addAutoLoadedFilters() {
        HelidonServiceLoader.builder(ServiceLoader.load(ConfigFilter.class)).defaultPriority(100).build().asList().stream().map(x$0 -> new LoadedFilterProvider((ConfigFilter)x$0)).forEach(this::addFilter);
    }

    private static class LoadedFilterProvider
    implements Function<Config, ConfigFilter> {
        private final ConfigFilter filter;

        private LoadedFilterProvider(ConfigFilter filter) {
            this.filter = filter;
        }

        @Override
        public ConfigFilter apply(Config config) {
            return this.filter;
        }

        public String toString() {
            return this.filter.toString();
        }
    }

    private static final class HelidonSourceWithPriority {
        private final ConfigSource configSource;
        private final Integer explicitPriority;

        private HelidonSourceWithPriority(ConfigSource configSource, Integer explicitPriority) {
            this.configSource = configSource;
            this.explicitPriority = explicitPriority;
        }

        ConfigSource unwrap() {
            return this.configSource;
        }

        int priority(ConfigContext context) {
            if (null != this.explicitPriority) {
                return this.explicitPriority;
            }
            return context.sourceRuntime(this.configSource).node("config_priority").flatMap(node -> node.value().map(Integer::parseInt)).orElseGet(() -> Priorities.find((Object)this.configSource, (int)100));
        }
    }

    private static final class PrioritizedConfigSource
    implements Prioritized {
        private final HelidonSourceWithPriority source;
        private final ConfigContext context;

        private PrioritizedConfigSource(HelidonSourceWithPriority source, ConfigContext context) {
            this.source = source;
            this.context = context;
        }

        private ConfigSourceRuntimeImpl runtime(ConfigContextImpl context) {
            return context.sourceRuntimeBase(this.source.unwrap());
        }

        public int priority() {
            return this.source.priority(this.context);
        }
    }

    private static final class HelidonMapperWrapper
    implements PrioritizedMapperProvider {
        private final ConfigMapperProvider delegate;
        private final int priority;

        private HelidonMapperWrapper(ConfigMapperProvider delegate, int priority) {
            this.delegate = delegate;
            this.priority = priority;
        }

        public int priority() {
            return this.priority;
        }

        @Override
        public Map<Class<?>, Function<Config, ?>> mappers() {
            return this.delegate.mappers();
        }

        @Override
        public Map<GenericType<?>, BiFunction<Config, ConfigMapper, ?>> genericTypeMappers() {
            return this.delegate.genericTypeMappers();
        }

        @Override
        public <T> Optional<Function<Config, T>> mapper(Class<T> type) {
            return this.delegate.mapper(type);
        }

        @Override
        public <T> Optional<BiFunction<Config, ConfigMapper, T>> mapper(GenericType<T> type) {
            return this.delegate.mapper(type);
        }

        public String toString() {
            return this.priority + ": " + this.delegate;
        }
    }

    private static interface PrioritizedMapperProvider
    extends Prioritized,
    ConfigMapperProvider {
    }

    static class InternalMapperProvider
    implements ConfigMapperProvider {
        private final Map<Class<?>, Function<Config, ?>> converterMap;
        private final String name;

        InternalMapperProvider(Map<Class<?>, Function<Config, ?>> converterMap, String name) {
            this.converterMap = converterMap;
            this.name = name;
        }

        @Override
        public Map<Class<?>, Function<Config, ?>> mappers() {
            return this.converterMap;
        }

        public String toString() {
            return this.name + " internal mappers";
        }
    }

    static final class EmptyConfigHolder {
        static final Config EMPTY = new BuilderImpl().sources(ConfigSources.empty()).overrides(OverrideSources.empty()).disableEnvironmentVariablesSource().disableSystemPropertiesSource().disableParserServices().disableFilterServices().changesExecutor(command -> {}).build();

        private EmptyConfigHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    static class ConfigContextImpl
    implements ConfigContext {
        private final Map<ConfigSource, ConfigSourceRuntimeImpl> runtimes = new IdentityHashMap<ConfigSource, ConfigSourceRuntimeImpl>();
        private final Executor changesExecutor;
        private final List<ConfigParser> configParsers;

        ConfigContextImpl(Executor changesExecutor, List<ConfigParser> configParsers) {
            this.changesExecutor = changesExecutor;
            this.configParsers = configParsers;
        }

        @Override
        public ConfigSourceRuntime sourceRuntime(ConfigSource source) {
            return this.sourceRuntimeBase(source);
        }

        private ConfigSourceRuntimeImpl sourceRuntimeBase(ConfigSource source) {
            return this.runtimes.computeIfAbsent(source, it -> new ConfigSourceRuntimeImpl(this, source));
        }

        Optional<ConfigParser> findParser(String mediaType) {
            Objects.requireNonNull(mediaType, "Unknown media type of resource.");
            return this.configParsers.stream().filter(parser -> parser.supportedMediaTypes().contains(mediaType)).findFirst();
        }

        Executor changesExecutor() {
            return this.changesExecutor;
        }

        List<String> supportedSuffixes() {
            LinkedList<String> result = new LinkedList<String>();
            this.configParsers.stream().map(ConfigParser::supportedSuffixes).forEach(result::addAll);
            return result;
        }
    }
}

