/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.common.parameters.Parameters;
import io.helidon.common.uri.UriQueryEmpty;
import io.helidon.common.uri.UriQueryImpl;
import java.net.URI;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public interface UriQuery
extends Parameters {
    public static UriQuery create(String query) {
        Objects.requireNonNull(query, "Raw query string cannot be null, use create(URI) or empty()");
        if (query.isEmpty()) {
            return UriQuery.empty();
        }
        return new UriQueryImpl(query);
    }

    public static UriQuery empty() {
        return UriQueryEmpty.INSTANCE;
    }

    public static UriQuery create(URI uri) {
        Objects.requireNonNull(uri, "URI cannot be null, use empty()");
        String rawQuery = uri.getRawQuery();
        return rawQuery == null ? UriQuery.empty() : UriQuery.create(rawQuery);
    }

    public String rawValue();

    public String value();

    public String getRaw(String var1) throws NoSuchElementException;

    public List<String> getAllRaw(String var1) throws NoSuchElementException;
}

