/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.common.uri.UriEncoding;
import java.util.Objects;

public class UriFragment {
    private static final UriFragment EMPTY = new UriFragment(null, null);
    private final String rawFragment;
    private String decodedFragment;

    private UriFragment(String rawFragment) {
        this.rawFragment = rawFragment;
    }

    private UriFragment(String encoded, String fragment) {
        this.rawFragment = encoded;
        this.decodedFragment = fragment;
    }

    public static UriFragment create(String rawFragment) {
        return new UriFragment(rawFragment);
    }

    public static UriFragment createFromDecoded(String fragment) {
        return new UriFragment(UriEncoding.encode(fragment, UriEncoding.Type.FRAGMENT), fragment);
    }

    public static UriFragment empty() {
        return EMPTY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UriFragment)) {
            return false;
        }
        UriFragment that = (UriFragment)o;
        return Objects.equals(this.rawFragment, that.rawFragment);
    }

    public int hashCode() {
        return Objects.hash(this.rawFragment);
    }

    public String toString() {
        if (this.rawFragment == null) {
            return "";
        }
        return this.value();
    }

    public boolean hasValue() {
        return this.rawFragment != null;
    }

    public String rawValue() {
        return this.rawFragment;
    }

    public String value() {
        if (this.decodedFragment == null) {
            this.decodedFragment = UriEncoding.decodeUri(this.rawFragment);
        }
        return this.decodedFragment;
    }
}

