/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.crypto;

import io.helidon.common.Base64Value;
import io.helidon.common.crypto.CryptoCommonConstants;
import io.helidon.common.crypto.CryptoException;
import java.security.MessageDigest;
import java.util.regex.Matcher;

public interface Digest {
    public Base64Value digest(Base64Value var1);

    default public boolean verify(Base64Value toVerify, Base64Value digestToVerify) {
        return MessageDigest.isEqual(this.digest(toVerify).toBytes(), digestToVerify.toBytes());
    }

    default public String digestString(Base64Value value) {
        return "helidon:2:" + this.digest(value).toBase64();
    }

    default public boolean verifyString(Base64Value toVerify, String digestToVerify) {
        Matcher matcher = CryptoCommonConstants.PREFIX_PATTERN.matcher(digestToVerify);
        if (matcher.matches()) {
            return this.verify(toVerify, Base64Value.createFromEncoded((String)matcher.group(2)));
        }
        throw new CryptoException("String does not contain Helidon prefix: " + digestToVerify);
    }
}

