/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.plugin;

import io.hawt.web.ServletHelpers;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PluginServlet.class);
    private static final String[] ATTRIBUTES = new String[]{"Context", "Domain", "Name", "Scripts"};
    private MBeanServer mBeanServer;
    private ObjectName pluginQuery;
    private final Converters converters = new Converters();
    private final JsonConvertOptions options = JsonConvertOptions.DEFAULT;

    public void init() throws ServletException {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.pluginQuery = new ObjectName("hawtio:type=plugin,name=*");
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Failed to create object name: ", (Throwable)e);
        }
        super.init();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        Set<ObjectInstance> objectInstances = this.mBeanServer.queryMBeans(this.pluginQuery, null);
        if (objectInstances.isEmpty()) {
            ServletHelpers.writeEmpty(out);
            return;
        }
        HashMap answer = new HashMap();
        for (ObjectInstance objectInstance : objectInstances) {
            AttributeList attributeList = null;
            try {
                attributeList = this.mBeanServer.getAttributes(objectInstance.getObjectName(), ATTRIBUTES);
            }
            catch (InstanceNotFoundException e) {
                LOG.warn("Object instance not found: " + objectInstance.getObjectName(), (Throwable)e);
            }
            catch (ReflectionException e) {
                LOG.warn("Failed to get attribute list for mbean: " + objectInstance.getObjectName(), (Throwable)e);
            }
            catch (SecurityException e) {
                LOG.warn("Security issue accessing mbean: " + objectInstance.getObjectName(), (Throwable)e);
            }
            if (attributeList == null || ATTRIBUTES.length != attributeList.size()) continue;
            HashMap pluginDefinition = new HashMap();
            attributeList.asList().forEach(attr -> pluginDefinition.put(attr.getName(), attr.getValue()));
            answer.put((String)pluginDefinition.get("Name"), pluginDefinition);
        }
        ServletHelpers.writeObject(this.converters, this.options, out, answer);
    }
}

