/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.kubernetes;

import io.hawt.util.Strings;
import io.hawt.web.kubernetes.DefaultProxyAddress;
import io.hawt.web.kubernetes.ServiceResolver;
import io.hawt.web.proxy.ProxyAddress;
import io.hawt.web.proxy.ProxyServlet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceServlet
extends ProxyServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceServlet.class);

    @Override
    protected ProxyAddress parseProxyAddress(HttpServletRequest servletRequest) {
        String url;
        String reqQueryString = servletRequest.getQueryString();
        String queryPostfix = "";
        if (Strings.isNotBlank(reqQueryString)) {
            queryPostfix = "?" + reqQueryString;
        }
        String password = null;
        String serviceName = servletRequest.getPathInfo();
        if (serviceName == null) {
            serviceName = "";
        }
        if (serviceName.startsWith("/")) {
            serviceName = serviceName.substring(1);
        }
        int idx = serviceName.indexOf(47);
        String servicePath = "/";
        if (idx > 0) {
            servicePath = serviceName.substring(idx);
            serviceName = serviceName.substring(0, idx);
        }
        if (serviceName.length() == 0) {
            serviceName = "kubernetes";
            servicePath = "/kubernetes/api/v1beta2/services";
        }
        if ((url = ServiceResolver.getSingleton().getServiceURL(serviceName)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No service for: " + serviceName + " path: " + servicePath);
            }
            return null;
        }
        url = url + servicePath + queryPostfix;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking: " + url + " from service: " + serviceName + " path: " + servicePath);
        }
        return new DefaultProxyAddress(url, null, password);
    }
}

