/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.util.IOHelper;
import io.hawt.web.ForbiddenReason;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.management.AttributeNotFoundException;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHelpers {
    protected static final String HEADER_HAWTIO_FORBIDDEN_REASON = "Hawtio-Forbidden-Reason";
    private static final Logger LOG = LoggerFactory.getLogger(ServletHelpers.class);
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";

    public static void doForbidden(HttpServletResponse response) {
        ServletHelpers.doForbidden(response, ForbiddenReason.NONE);
    }

    public static void doForbidden(HttpServletResponse response, ForbiddenReason reason) {
        try {
            response.setStatus(403);
            response.setContentLength(0);
            response.setHeader(HEADER_HAWTIO_FORBIDDEN_REASON, reason.name());
            response.flushBuffer();
        }
        catch (IOException ioe) {
            LOG.debug("Failed to send forbidden response: {}", (Object)ioe.toString());
        }
    }

    public static void doAuthPrompt(String realm, HttpServletResponse response) {
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            LOG.debug("Failed to send auth response: {}", (Object)ioe.toString());
        }
    }

    public static void sendJSONResponse(HttpServletResponse response, boolean value) throws IOException {
        ServletHelpers.sendJSONResponse(response, String.valueOf(value));
    }

    public static void sendJSONResponse(HttpServletResponse response, String json) throws IOException {
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.println(json);
        writer.flush();
        writer.close();
    }

    public static JSONObject readObject(BufferedReader reader) throws IOException {
        String data = IOHelper.readFully(reader);
        return new JSONObject(data);
    }

    public static void writeEmpty(PrintWriter out) {
        out.write("{}");
        out.flush();
        out.close();
    }

    public static void writeObject(Converters converters, JsonConvertOptions options, PrintWriter out, Object data) {
        Object result = null;
        try {
            result = converters.getToJsonConverter().convertToJson(data, null, options);
        }
        catch (AttributeNotFoundException e) {
            LOG.warn("Failed to convert object to json", (Throwable)e);
        }
        if (result != null) {
            out.write(result.toString());
            out.flush();
            out.close();
        } else {
            ServletHelpers.writeEmpty(out);
        }
    }

    public static InputStream loadFile(String path) {
        if (path.startsWith("classpath:")) {
            String classPathLocation = path.substring(10);
            return ServletHelpers.class.getClassLoader().getResourceAsStream(classPathLocation);
        }
        try {
            if (!path.contains(":")) {
                path = "file://" + path;
            }
            return new URL(path).openStream();
        }
        catch (Exception e) {
            LOG.warn("Couldn't find keycloak config file on location: {}", (Object)path);
            LOG.debug("Couldn't find keycloak config file", (Throwable)e);
            return null;
        }
    }
}

