/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.HawtioContextListener;
import io.hawt.springboot.security.SpringSecurityJAASConfiguration;
import io.hawt.system.ConfigManager;
import io.hawt.web.auth.AuthenticationConfiguration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.login.Configuration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringHawtioContextListener
extends HawtioContextListener {
    public final String servletPath;

    public SpringHawtioContextListener(ConfigManager configManager, String servletPath) {
        super(configManager);
        this.servletPath = Objects.requireNonNull(servletPath);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        super.contextInitialized(servletContextEvent);
        servletContextEvent.getServletContext().setAttribute("hawtioServletPath", (Object)this.servletPath);
    }

    protected void configureAuthenticationProviders(ServletContext servletContext, AuthenticationConfiguration authConfig) {
        try {
            for (WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext); context != null; context = context.getParent()) {
                Class<?> sfcClass = Class.forName("org.springframework.security.web.SecurityFilterChain");
                Class<?> hawtioSpringSecurityLoginModule = Class.forName("io.hawt.springboot.security.HawtioSpringSecurityLoginModule");
                Map filterChains = context.getBeansOfType(sfcClass);
                if (filterChains.isEmpty()) continue;
                authConfig.setSpringSecurityEnabled(true);
                authConfig.setConfiguration((Configuration)new SpringSecurityJAASConfiguration(authConfig));
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!authConfig.isSpringSecurityEnabled()) {
            super.configureAuthenticationProviders(servletContext, authConfig);
        }
    }
}

