/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.io.ByteBufferAccumulator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedResponseHandler
extends Handler.Wrapper {
    public static final String BUFFER_SIZE_ATTRIBUTE_NAME = BufferedResponseHandler.class.getName() + ".buffer-size";
    private static final Logger LOG = LoggerFactory.getLogger(BufferedResponseHandler.class);
    private final IncludeExclude<String> _methods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();

    public BufferedResponseHandler() {
        this((Handler)null);
    }

    public BufferedResponseHandler(Handler handler) {
        super(handler);
        this._methods.include(HttpMethod.GET.asString());
        for (String type : MimeTypes.DEFAULTS.getMimeMap().values()) {
            if (!type.startsWith("image/") && !type.startsWith("audio/") && !type.startsWith("video/")) continue;
            this._mimeTypes.exclude(type);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} mime types {}", (Object)this, this._mimeTypes);
        }
    }

    public IncludeExclude<String> getMethodIncludeExclude() {
        return this._methods;
    }

    public IncludeExclude<String> getPathIncludeExclude() {
        return this._paths;
    }

    public IncludeExclude<String> getMimeIncludeExclude() {
        return this._mimeTypes;
    }

    protected boolean isMimeTypeBufferable(String mimetype) {
        return this._mimeTypes.test(mimetype);
    }

    protected boolean isPathBufferable(String requestURI) {
        if (requestURI == null) {
            return true;
        }
        return this._paths.test(requestURI);
    }

    protected boolean shouldBuffer(Response response, boolean last) {
        if (last) {
            return false;
        }
        int status = response.getStatus();
        if (HttpStatus.hasNoBody(status) || HttpStatus.isRedirection(status)) {
            return false;
        }
        String ct = response.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (ct == null) {
            return true;
        }
        ct = MimeTypes.getContentTypeWithoutCharset(ct);
        return this.isMimeTypeBufferable(StringUtil.asciiToLowerCase(ct));
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} handle {} in {}", new Object[]{this, request, request.getContext()});
        }
        if (!this._methods.test(request.getMethod())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} excluded by method {}", (Object)this, (Object)request);
            }
            return super.handle(request, response, callback);
        }
        String path = Request.getPathInContext(request);
        if (!this.isPathBufferable(path)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} excluded by path {}", (Object)this, (Object)request);
            }
            return super.handle(request, response, callback);
        }
        String mimeType = request.getContext().getMimeTypes().getMimeByExtension(path);
        if (mimeType != null && !this.isMimeTypeBufferable(mimeType = MimeTypes.getContentTypeWithoutCharset(mimeType))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} excluded by path suffix mime type {}", (Object)this, (Object)request);
            }
            return super.handle(request, response, callback);
        }
        BufferedResponse bufferedResponse = new BufferedResponse(request, response, callback);
        return next.handle(request, bufferedResponse, bufferedResponse);
    }

    private class BufferedResponse
    extends Response.Wrapper
    implements Callback {
        private final Callback _callback;
        private CountingByteBufferAccumulator _accumulator;
        private boolean _firstWrite;

        private BufferedResponse(Request request, Response response, Callback callback) {
            super(request, response);
            this._firstWrite = true;
            this._callback = callback;
        }

        @Override
        public void write(final boolean last, ByteBuffer byteBuffer, Callback callback) {
            if (this._firstWrite) {
                if (BufferedResponseHandler.this.shouldBuffer(this, last)) {
                    ConnectionMetaData connectionMetaData = this.getRequest().getConnectionMetaData();
                    ByteBufferPool bufferPool = connectionMetaData.getConnector().getByteBufferPool();
                    boolean useOutputDirectByteBuffers = connectionMetaData.getHttpConfiguration().isUseOutputDirectByteBuffers();
                    this._accumulator = new CountingByteBufferAccumulator(bufferPool, useOutputDirectByteBuffers, this.getBufferSize());
                }
                this._firstWrite = false;
            }
            if (this._accumulator != null) {
                final ByteBuffer current = byteBuffer != null ? byteBuffer : BufferUtil.EMPTY_BUFFER;
                IteratingNestedCallback writer = new IteratingNestedCallback(callback){
                    private boolean complete;

                    @Override
                    protected IteratingCallback.Action process() {
                        if (this.complete) {
                            return IteratingCallback.Action.SUCCEEDED;
                        }
                        boolean write = BufferedResponse.this._accumulator.copyBuffer(current);
                        boolean bl = this.complete = last && !current.hasRemaining();
                        if (write || this.complete) {
                            RetainableByteBuffer buffer = BufferedResponse.this._accumulator.takeRetainableByteBuffer();
                            BufferedResponse.super.write(this.complete, buffer.getByteBuffer(), Callback.from((Callback)this, buffer::release));
                            return IteratingCallback.Action.SCHEDULED;
                        }
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                };
                writer.iterate();
            } else {
                super.write(last, byteBuffer, callback);
            }
        }

        private int getBufferSize() {
            Object attribute = this.getRequest().getAttribute(BUFFER_SIZE_ATTRIBUTE_NAME);
            return attribute instanceof Integer ? (Integer)attribute : Integer.MAX_VALUE;
        }

        @Override
        public void succeeded() {
            if (this._accumulator != null) {
                RetainableByteBuffer buffer = this._accumulator.takeRetainableByteBuffer();
                super.write(true, buffer.getByteBuffer(), Callback.from(this._callback, () -> {
                    buffer.release();
                    this._accumulator.close();
                }));
            } else {
                this._callback.succeeded();
            }
        }

        @Override
        public void failed(Throwable x) {
            if (this._accumulator != null) {
                this._accumulator.close();
            }
            this._callback.failed(x);
        }
    }

    private static class CountingByteBufferAccumulator
    implements AutoCloseable {
        private final ByteBufferAccumulator _accumulator;
        private final int _maxSize;
        private int _accumulatedCount;

        private CountingByteBufferAccumulator(ByteBufferPool bufferPool, boolean direct, int maxSize) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("maxSize must be > 0, was: " + maxSize);
            }
            this._maxSize = maxSize;
            this._accumulator = new ByteBufferAccumulator(bufferPool, direct);
        }

        private boolean copyBuffer(ByteBuffer buffer) {
            int remainingCapacity = this.space();
            if (buffer.remaining() >= remainingCapacity) {
                this._accumulatedCount += remainingCapacity;
                int end = buffer.position() + remainingCapacity;
                this._accumulator.copyBuffer(buffer.duplicate().limit(end));
                buffer.position(end);
                return true;
            }
            this._accumulatedCount += buffer.remaining();
            this._accumulator.copyBuffer(buffer);
            return false;
        }

        private int space() {
            return this._maxSize - this._accumulatedCount;
        }

        private RetainableByteBuffer takeRetainableByteBuffer() {
            this._accumulatedCount = 0;
            return this._accumulator.takeRetainableByteBuffer();
        }

        @Override
        public void close() {
            this._accumulatedCount = 0;
            this._accumulator.close();
        }
    }
}

