/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.embedded;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.Slf4jLog;
import org.eclipse.jetty.webapp.WebAppContext;

public class Main {
    private String contextPath = "/hawtio";
    private int port = 8080;
    private String war;
    private String warLocation;
    private String[] warPaths;
    private String extraClassPath;

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.out.println("Usage: locationOfHawtioWar portName contextPath");
            return;
        }
        Main main = new Main();
        if (args.length > 0) {
            main.setWar(args[0]);
        }
        if (args.length > 1) {
            String portText = args[1];
            try {
                int port = Integer.parseInt(portText);
                main.setPort(port);
            }
            catch (NumberFormatException e) {
                System.out.println("Failed to parse port number '" + portText + "'. " + e);
                return;
            }
        }
        if (args.length > 2) {
            main.setContextPath(args[2]);
        }
        Main.doRun(main);
    }

    public static void doRun(Main main) {
        try {
            main.run();
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
        }
    }

    public void run() throws Exception {
        System.setProperty("org.eclipse.jetty.util.log.class", Slf4jLog.class.getName());
        Log.setLog((Logger)new Slf4jLog("jetty"));
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(this.contextPath);
        String war = this.getWarLocation();
        if (war == null) {
            war = this.findWar(this.getWar());
        }
        if (war == null) {
            war = this.findWar(this.getWarPaths());
        }
        if (war == null) {
            throw new IllegalArgumentException("No war property set!");
        }
        webapp.setWar(war);
        webapp.setParentLoaderPriority(true);
        webapp.setLogUrlOnStart(true);
        if (this.extraClassPath != null) {
            webapp.setExtraClasspath(this.extraClassPath);
        }
        Server server = new Server(this.port);
        server.setHandler((Handler)webapp);
        System.out.println("About to start war " + war);
        server.start();
        System.out.println();
        System.out.println("hawtio: Don't cha wish your console was hawt like me!");
        System.out.println("=====================================================");
        System.out.println();
        System.out.println("http://localhost:" + this.port + this.contextPath);
        System.out.println();
        server.join();
    }

    protected String findWar(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                File[] wars;
                String name;
                File file = new File(path);
                if (!file.exists()) continue;
                if (file.isFile() && this.isWarFileName(name = file.getName())) {
                    return file.getPath();
                }
                if (!file.isDirectory() || (wars = file.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return Main.this.isWarFileName(name);
                    }
                })) == null || wars.length <= 0) continue;
                return wars[0].getPath();
            }
        }
        return null;
    }

    protected boolean isWarFileName(String name) {
        return name.toLowerCase().endsWith(".war");
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getWar() {
        return this.war;
    }

    public void setWar(String war) {
        this.war = war;
    }

    public String[] getWarPaths() {
        return this.warPaths;
    }

    public String getWarLocation() {
        return this.warLocation;
    }

    public void setWarLocation(String warLocation) {
        this.warLocation = warLocation;
    }

    public void setWarPaths(String ... warPaths) {
        this.warPaths = warPaths;
    }

    public String getExtraClassPath() {
        return this.extraClassPath;
    }

    public void setExtraClassPath(String extraClassPath) {
        this.extraClassPath = extraClassPath;
    }
}

