/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.maven.rdfio.filter;

import io.github.qudtlib.maven.rdfio.filter.AbstractFilter;
import io.github.qudtlib.maven.rdfio.filter.Filter;
import io.github.qudtlib.maven.rdfio.filter.PredicateTest;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractPredicateFilter
extends AbstractFilter
implements Filter {
    protected boolean include;
    protected List<Predicate<Statement>> statementPredicates = new ArrayList<Predicate<Statement>>();

    public AbstractPredicateFilter(boolean include) {
        this.include = include;
    }

    @Override
    public void filter(Model model) {
        StmtIterator it = model.listStatements();
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            if (this.include) {
                if (!this.statementPredicates.stream().noneMatch(pred -> pred.test(stmt))) continue;
                it.remove();
                continue;
            }
            if (!this.statementPredicates.stream().anyMatch(pred -> pred.test(stmt))) continue;
            it.remove();
        }
    }

    @Parameter
    public void setPredicate(String predicate) {
        this.statementPredicates.add(new PredicateTest(predicate));
    }
}

