/*
 * Decompiled with CFR 0.152.
 */
package io.github.qudtlib.maven.rdfio;

import io.github.qudtlib.maven.rdfio.AbstractRdfioMojo;
import io.github.qudtlib.maven.rdfio.product.EachFile;
import io.github.qudtlib.maven.rdfio.product.Product;
import io.github.qudtlib.maven.rdfio.product.Products;
import io.github.qudtlib.maven.rdfio.product.SingleFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="make", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class MakeMojo
extends AbstractRdfioMojo {
    @Parameter(readonly=true, defaultValue="target/rdfio-products")
    private String defaultOutputDir;
    @Parameter(required=true)
    private Products products;

    public String getDefaultOutputDir() {
        return this.defaultOutputDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Making RDF files");
        for (Product product : this.products.getProducts()) {
            try {
                if (product instanceof SingleFile) {
                    this.makeSingleFile((SingleFile)product);
                    continue;
                }
                if (!(product instanceof EachFile)) continue;
                this.makeEachFile((EachFile)product);
            }
            catch (FileNotFoundException e) {
                throw new MojoFailureException("Error making RDF file for product" + product.describe(), (Throwable)e);
            }
        }
    }

    private void makeSingleFile(SingleFile singleFileProduct) throws MojoFailureException, FileNotFoundException, MojoExecutionException {
        singleFileProduct.setLog(this.getLog());
        this.getLog().info((CharSequence)"Make RDF files configuration:");
        String[] inputFiles = this.getFilesForPatterns(singleFileProduct.getInput());
        this.getLog().info((CharSequence)("\tinput: " + Arrays.stream(inputFiles).collect(Collectors.joining("\n\t", "\n\t", "\n"))));
        this.getLog().info((CharSequence)("\toutput: " + singleFileProduct.getOutputFile()));
        if (singleFileProduct.getOutputFile() == null) {
            throw new MojoFailureException("You must specify the name of the output file we are making!");
        }
        if (singleFileProduct.isSkip()) {
            this.getLog().info((CharSequence)("Skip making RDF file " + singleFileProduct.getOutputFile()));
            return;
        }
        this.debug("Loading data", new Object[0]);
        Model model = this.loadRdf(inputFiles);
        singleFileProduct.process(model);
        this.writeModelToFile(singleFileProduct.getOutputFile(), model, "writing RDF data to %s");
    }

    private void makeEachFile(EachFile eachFileProduct) throws MojoFailureException, FileNotFoundException, MojoExecutionException {
        eachFileProduct.setLog(this.getLog());
        this.getLog().info((CharSequence)"Make RDF files configuration:");
        String[] inputFiles = this.getFilesForPatterns(eachFileProduct.getInput());
        this.getLog().info((CharSequence)("\tinput: " + Arrays.stream(inputFiles).collect(Collectors.joining("\n\t", "\n\t", "\n"))));
        String outputDir = Optional.ofNullable(eachFileProduct.getOutputDir()).orElse(this.getDefaultOutputDir());
        if (eachFileProduct.isReplaceInputFiles()) {
            this.getLog().info((CharSequence)"\toutput: input files are overwritten by result");
        } else {
            this.getLog().info((CharSequence)("\toutput dir: " + outputDir));
        }
        if (eachFileProduct.isSkip()) {
            this.getLog().info((CharSequence)"Skip making RDF file(s)");
            return;
        }
        this.debug("Loading data", new Object[0]);
        for (String inputFile : inputFiles) {
            Model model = this.loadRdf(new String[]{inputFile});
            eachFileProduct.process(model);
            if (eachFileProduct.isReplaceInputFiles()) {
                this.writeModelToFile(inputFile, model, "writing RDF data to %s");
                continue;
            }
            String outputFile = new File(outputDir, new File(inputFile).getName()).toString();
            this.writeModelToFile(outputFile, model, "writing RDF data to %s");
        }
    }
}

