/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpBuilder;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.HttpConfigs;
import groovyx.net.http.HttpObjectConfig;
import groovyx.net.http.ProxyInfo;
import groovyx.net.http.ToServer;
import groovyx.net.http.util.IoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import okhttp3.Authenticator;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;

public class OkHttpBuilder
extends HttpBuilder {
    private static final Function<HttpObjectConfig, ? extends HttpBuilder> okFactory = OkHttpBuilder::new;
    private static final String OPTIONS = "OPTIONS";
    private static final String TRACE = "TRACE";
    private final ChainedHttpConfig config;
    private final HttpObjectConfig.Client clientConfig;
    private final Executor executor;
    private final OkHttpClient client;

    protected OkHttpBuilder(HttpObjectConfig config) {
        super(config);
        ProxyInfo pinfo;
        Consumer clientCustomizer;
        HttpConfig.Auth auth;
        this.config = new HttpConfigs.ThreadSafeHttpConfig(config.getChainedConfig());
        this.clientConfig = config.getClient();
        this.executor = config.getExecution().getExecutor();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        SSLContext sslContext = config.getExecution().getSslContext();
        if (sslContext != null) {
            builder.sslSocketFactory(sslContext.getSocketFactory());
            builder.hostnameVerifier(config.getExecution().getHostnameVerifier());
        }
        if ((auth = config.getRequest().getAuth()) != null && auth.getAuthType() == HttpConfig.AuthType.DIGEST) {
            ConcurrentHashMap authCache = new ConcurrentHashMap();
            builder.addInterceptor((Interceptor)new AuthenticationCacheInterceptor(authCache));
            builder.authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)new DigestAuthenticator(new Credentials(auth.getUser(), auth.getPassword())), authCache));
        }
        if ((clientCustomizer = this.clientConfig.getClientCustomizer()) != null) {
            clientCustomizer.accept(builder);
        }
        if (this.usesProxy(pinfo = config.getExecution().getProxyInfo())) {
            builder.proxy(pinfo.getProxy());
        }
        this.client = builder.build();
    }

    private boolean usesProxy(ProxyInfo pinfo) {
        return pinfo != null && pinfo.getProxy().type() != Proxy.Type.DIRECT;
    }

    public Object getClientImplementation() {
        return this.client;
    }

    public static HttpBuilder configure(@DelegatesTo(value=HttpObjectConfig.class) Closure closure) {
        return OkHttpBuilder.configure(okFactory, (Closure)closure);
    }

    public static HttpBuilder configure(Consumer<HttpObjectConfig> configuration) {
        return OkHttpBuilder.configure(okFactory, configuration);
    }

    protected ChainedHttpConfig getObjectConfig() {
        return this.config;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    protected Object doGet(ChainedHttpConfig chainedConfig) {
        return this.execute(url -> new Request.Builder().get().url(url), chainedConfig);
    }

    protected Object doHead(ChainedHttpConfig chainedConfig) {
        return this.execute(url -> new Request.Builder().head().url(url), chainedConfig);
    }

    protected Object doPost(ChainedHttpConfig chainedConfig) {
        return this.execute(url -> new Request.Builder().post(this.resolveRequestBody(chainedConfig)).url(url), chainedConfig);
    }

    protected Object doPut(ChainedHttpConfig chainedConfig) {
        return this.execute(url -> new Request.Builder().put(this.resolveRequestBody(chainedConfig)).url(url), chainedConfig);
    }

    protected Object doPatch(ChainedHttpConfig chainedConfig) {
        return this.execute(url -> new Request.Builder().patch(this.resolveRequestBody(chainedConfig)).url(url), chainedConfig);
    }

    protected Object doDelete(ChainedHttpConfig chainedConfig) {
        return this.execute(url -> new Request.Builder().delete().url(url), chainedConfig);
    }

    protected Object doOptions(ChainedHttpConfig config) {
        return this.execute(url -> new Request.Builder().method(OPTIONS, null).url(url), config);
    }

    protected Object doTrace(ChainedHttpConfig config) {
        return this.execute(url -> new Request.Builder().method(TRACE, null).url(url), config);
    }

    public void close() throws IOException {
    }

    private RequestBody resolveRequestBody(ChainedHttpConfig chainedConfig) {
        RequestBody body;
        ChainedHttpConfig.ChainedRequest cr = chainedConfig.getChainedRequest();
        if (cr.actualBody() != null) {
            OkHttpToServer toServer = new OkHttpToServer(chainedConfig);
            chainedConfig.findEncoder().accept(chainedConfig, toServer);
            body = toServer;
        } else {
            body = RequestBody.create((MediaType)OkHttpBuilder.resolveMediaType(cr.actualContentType(), cr.actualCharset()), (String)"");
        }
        return body;
    }

    private static MediaType resolveMediaType(String contentType, Charset charset) {
        if (contentType != null) {
            if (charset != null) {
                return MediaType.parse((String)(contentType + "; charset=" + charset.toString().toLowerCase()));
            }
            return MediaType.parse((String)contentType);
        }
        return null;
    }

    private void applyHeaders(Request.Builder requestBuilder, ChainedHttpConfig.ChainedRequest cr) throws URISyntaxException {
        for (Map.Entry entry : cr.actualHeaders(new LinkedHashMap()).entrySet()) {
            requestBuilder.addHeader((String)entry.getKey(), entry.getValue() != null ? ((CharSequence)entry.getValue()).toString() : null);
        }
        for (Map.Entry e : this.cookiesToAdd(this.clientConfig, cr).entrySet()) {
            requestBuilder.addHeader((String)e.getKey(), (String)e.getValue());
        }
    }

    private static void applyAuth(Request.Builder requestBuilder, ChainedHttpConfig chainedConfig) {
        HttpConfig.Auth auth = chainedConfig.getChainedRequest().actualAuth();
        if (auth != null) {
            switch (auth.getAuthType()) {
                case BASIC: {
                    requestBuilder.addHeader("Authorization", okhttp3.Credentials.basic((String)auth.getUser(), (String)auth.getPassword()));
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object execute(Function<HttpUrl, Request.Builder> makeBuilder, ChainedHttpConfig chainedConfig) {
        try {
            ChainedHttpConfig.ChainedRequest cr = chainedConfig.getChainedRequest();
            URI uri = cr.getUri().toURI();
            HttpUrl httpUrl = HttpUrl.get((URI)uri);
            Request.Builder requestBuilder = makeBuilder.apply(httpUrl);
            this.applyHeaders(requestBuilder, cr);
            OkHttpBuilder.applyAuth(requestBuilder, chainedConfig);
            try (Response response = this.client.newCall(requestBuilder.build()).execute();){
                Object object = HttpBuilder.ResponseHandlerFunction.HANDLER_FUNCTION.apply(chainedConfig, (FromServer)new OkHttpFromServer(chainedConfig.getChainedRequest().getUri().toURI(), response));
                return object;
            }
        }
        catch (Exception e) {
            return this.handleException(chainedConfig.getChainedResponse(), e);
        }
    }

    private static class OkHttpToServer
    extends RequestBody
    implements ToServer {
        private ChainedHttpConfig config;
        private byte[] bytes;

        private OkHttpToServer(ChainedHttpConfig config) {
            this.config = config;
        }

        public void toServer(InputStream inputStream) {
            try {
                this.bytes = IoUtils.streamToBytes((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public MediaType contentType() {
            return OkHttpBuilder.resolveMediaType(this.config.findContentType(), this.config.findCharset());
        }

        public long contentLength() throws IOException {
            return this.bytes.length;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.write(this.bytes);
        }
    }

    private class OkHttpFromServer
    implements FromServer {
        private final URI uri;
        private final Response response;
        private List<FromServer.Header<?>> headers;
        private boolean body;

        private OkHttpFromServer(URI uri, Response response) {
            this.uri = uri;
            this.response = response;
            this.headers = this.populateHeaders();
            OkHttpBuilder.this.addCookieStore(uri, this.headers);
            try {
                this.body = !response.body().source().exhausted() && response.peekBody(1L).bytes().length > 0;
            }
            catch (IOException e) {
                this.body = false;
            }
        }

        private List<FromServer.Header<?>> populateHeaders() {
            Headers headers = this.response.headers();
            ArrayList ret = new ArrayList();
            for (String name : headers.names()) {
                List values = headers.values(name);
                for (String value : values) {
                    ret.add(FromServer.Header.keyValue((String)name, (String)value));
                }
            }
            return ret;
        }

        public InputStream getInputStream() {
            return this.response.body().byteStream();
        }

        public int getStatusCode() {
            return this.response.code();
        }

        public String getMessage() {
            return this.response.message();
        }

        public List<FromServer.Header<?>> getHeaders() {
            return this.headers;
        }

        public boolean getHasBody() {
            return this.body;
        }

        public URI getUri() {
            return this.uri;
        }

        public void finish() {
            this.response.close();
        }
    }
}

