/*
 * Decompiled with CFR 0.152.
 */
package com.github.dkorotych.gradle.maven.exec;

import com.github.dkorotych.gradle.maven.CommandLineCreator;
import com.github.dkorotych.gradle.maven.MavenOptions;
import com.github.dkorotych.gradle.maven.exec.MavenExecSpec;
import com.github.dkorotych.gradle.maven.exec.MavenProperties;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;
import org.gradle.process.ProcessForkOptions;

public class MavenExecSpecDelegate
implements MavenExecSpec {
    private final MavenProperties properties = new MavenProperties();
    private final ExecSpec delegate;
    private final Project project;

    public MavenExecSpecDelegate(ExecSpec delegate, Project project) {
        this.delegate = Objects.requireNonNull(delegate, "Exec specification delegate should be not null");
        this.project = Objects.requireNonNull(project, "Project should be not null");
    }

    @Override
    public File getMavenDir() {
        return this.properties.getMavenDir();
    }

    @Override
    public void setMavenDir(File dir) {
        this.properties.setMavenDir(dir);
    }

    @Override
    public Set<String> getGoals() {
        return this.properties.getGoals();
    }

    @Override
    public MavenOptions getOptions() {
        return this.properties.getOptions();
    }

    public MavenExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.delegate.setIgnoreExitValue(ignoreExitValue);
        return this;
    }

    public boolean isIgnoreExitValue() {
        return this.delegate.isIgnoreExitValue();
    }

    public MavenExecSpec setStandardInput(InputStream inputStream) {
        this.delegate.setStandardInput(inputStream);
        return this;
    }

    public InputStream getStandardInput() {
        return this.delegate.getStandardInput();
    }

    public MavenExecSpec setStandardOutput(OutputStream outputStream) {
        this.delegate.setStandardOutput(outputStream);
        return this;
    }

    public OutputStream getStandardOutput() {
        return this.delegate.getStandardOutput();
    }

    public MavenExecSpec setErrorOutput(OutputStream outputStream) {
        this.delegate.setErrorOutput(outputStream);
        return this;
    }

    public OutputStream getErrorOutput() {
        return this.delegate.getErrorOutput();
    }

    public List<String> getCommandLine() {
        this.getExecutable();
        return this.delegate.getCommandLine();
    }

    public String getExecutable() {
        CommandLineCreator creator = new CommandLineCreator(this, this.project);
        this.delegate.setExecutable(creator.getExecutable());
        this.delegate.setArgs(creator.getArguments());
        return this.delegate.getExecutable();
    }

    public void setExecutable(String executable) {
        throw new UnsupportedOperationException();
    }

    public void setExecutable(Object executable) {
        throw new UnsupportedOperationException();
    }

    public MavenExecSpec executable(Object executable) {
        throw new UnsupportedOperationException();
    }

    public File getWorkingDir() {
        return this.delegate.getWorkingDir();
    }

    public void setWorkingDir(File dir) {
        this.delegate.setWorkingDir(dir);
    }

    public void setWorkingDir(Object dir) {
        this.delegate.setWorkingDir(dir);
    }

    public MavenExecSpec workingDir(Object dir) {
        this.delegate.setWorkingDir(dir);
        return this;
    }

    public Map<String, Object> getEnvironment() {
        return this.delegate.getEnvironment();
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        if (environmentVariables == null) {
            this.delegate.getEnvironment().clear();
        } else {
            this.delegate.setEnvironment(environmentVariables);
        }
    }

    public MavenExecSpec environment(Map<String, ?> environmentVariables) {
        this.setEnvironment(environmentVariables);
        return this;
    }

    public MavenExecSpec environment(String name, Object value) {
        this.delegate.environment(name, value);
        return this;
    }

    public MavenExecSpec copyTo(ProcessForkOptions options) {
        throw new UnsupportedOperationException();
    }
}

