/*
 * Decompiled with CFR 0.152.
 */
package com.github.dkorotych.gradle.maven;

import com.github.dkorotych.gradle.maven.MavenExecutableProvider;
import com.github.dkorotych.gradle.maven.MemoizedSupplier;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public class MavenDescriptor {
    private static final String CHARSET = Charset.forName(SystemUtils.FILE_ENCODING).name();
    private final File workingDir;
    private final Project project;
    private final MavenExecutableProvider executableProvider;
    private final Supplier<String> versionSupplier;
    private final Supplier<Set<String>> supportedOptionsSupplier;

    public MavenDescriptor(Path mavenHome, Project project) {
        this(mavenHome, project.getProjectDir(), project);
    }

    public MavenDescriptor(Path mavenHome, File workingDir, Project project) {
        this.workingDir = workingDir;
        this.project = project;
        this.executableProvider = new MavenExecutableProvider(mavenHome);
        this.versionSupplier = MemoizedSupplier.of(() -> this.parseVersion(this.execute("--version")));
        this.supportedOptionsSupplier = MemoizedSupplier.of(() -> this.parseSupportedOptions(this.execute("--help")));
    }

    public static boolean isMavenExecutionFile(File file) {
        return Optional.ofNullable(file).filter(File::isFile).map(File::getName).filter(name -> "mvn".equals(name) || "mvn.cmd".equals(name) || "mvn.bat".equals(name)).isPresent();
    }

    public static boolean isMavenExecutionWrapperFile(File file) {
        return Optional.ofNullable(file).filter(File::isFile).map(File::getName).filter(name -> "mvnw".equals(name) || "mvnw.cmd".equals(name)).isPresent();
    }

    public String getVersion() {
        return this.versionSupplier.get();
    }

    public Set<String> getSupportedOptions() {
        return this.supportedOptionsSupplier.get();
    }

    public String getExecutable() {
        return this.executableProvider.getExecutable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseVersion(InputStream stream) {
        Pattern pattern = Pattern.compile("^\\QApache Maven \\E(\\S+)(?:.+)?$");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String string = reader.lines().map(pattern::matcher).filter(Matcher::find).map(matcher -> matcher.group(1)).findAny().orElse(null);
            return string;
        }
        catch (IOException e) {
            throw new GradleException("Can't parse Maven version", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> parseSupportedOptions(InputStream stream) {
        Pattern pattern = Pattern.compile("^\\s+(?:-\\w+,)?(--\\S+).+$");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            Set<String> set = reader.lines().map(pattern::matcher).filter(Matcher::find).map(matcher -> matcher.group(1)).collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            throw new GradleException("Can't parse Maven supported options", (Throwable)e);
        }
    }

    InputStream execute(String option) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        try {
            this.project.exec(execSpec -> {
                execSpec.workingDir((Object)this.workingDir);
                execSpec.executable((Object)this.getExecutable());
                execSpec.setStandardOutput((OutputStream)outputStream);
                execSpec.setErrorOutput((OutputStream)errorStream);
                execSpec.setArgs(Collections.singletonList(option));
            }).assertNormalExitValue();
        }
        catch (Exception e) {
            String description = this.readMessage(errorStream);
            if (StringUtils.isBlank((CharSequence)description)) {
                description = e.getMessage();
            }
            throw new GradleException(description, (Throwable)e);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private String readMessage(ByteArrayOutputStream stream) {
        try {
            return stream.toString(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new GradleException("Can't read response from error stream", (Throwable)e);
        }
    }
}

