/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.webdriver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.MutableCapabilities;

public class OptionsWithArguments
extends MutableCapabilities {
    private static final long serialVersionUID = -5948442823984189597L;
    private String capability;
    private List<String> args = new ArrayList<String>();

    public OptionsWithArguments(String browserType, String capability) {
        this.setCapability("browserName", browserType);
        this.capability = capability;
    }

    public OptionsWithArguments addArguments(String ... arguments) {
        this.addArguments(Collections.unmodifiableList(Arrays.asList(arguments)));
        return this;
    }

    public OptionsWithArguments addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public Map<String, Object> asMap() {
        TreeMap toReturn = new TreeMap(super.asMap());
        TreeMap<String, List<String>> options = new TreeMap<String, List<String>>();
        options.put("args", Collections.unmodifiableList(this.args));
        toReturn.put(this.capability, options);
        return Collections.unmodifiableMap(toReturn);
    }
}

