/*
 * Decompiled with CFR 0.152.
 */
package io.github.azmaah.eclipse.transformer.task;

import io.github.azmaah.eclipse.transformer.task.BaseTask;
import java.util.ArrayList;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

public abstract class Transform
extends BaseTask {
    private static final String TASK_DESCRIPTION = "Transforms the jars given in the sourceDir";
    public static final String TASK_NAME = "runTransformer";

    @InputDirectory
    @SkipWhenEmpty
    public abstract DirectoryProperty getSourceDir();

    @OutputDirectory
    public abstract DirectoryProperty getDistDir();

    @InputFile
    @Optional
    public abstract RegularFileProperty getSelectionRules();

    @InputFile
    @Optional
    public abstract RegularFileProperty getRenamesRules();

    @InputFile
    @Optional
    public abstract RegularFileProperty getVersionsRules();

    @InputFile
    @Optional
    public abstract RegularFileProperty getBundlesRules();

    @InputFile
    @Optional
    public abstract RegularFileProperty getDirectRules();

    @InputFile
    @Optional
    public abstract RegularFileProperty getTextMasterRules();

    public Transform() {
        this.setGroup("transformer");
        this.setDescription(TASK_DESCRIPTION);
        this.dependsOn(new Object[]{"setupTransformer"});
    }

    @TaskAction
    void apply() {
        this.getProject().delete(new Object[]{this.getDistDir()});
        Directory cli = (Directory)this.cliDir.get();
        String sourceDir = ((Directory)this.getSourceDir().get()).getAsFile().getPath();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(sourceDir);
        args.add(this.getDistDir().get());
        if (this.getSelectionRules().isPresent()) {
            args.add("--selection");
            args.add(((RegularFile)this.getSelectionRules().get()).getAsFile().getPath());
        }
        if (this.getRenamesRules().isPresent()) {
            args.add("--renames");
            args.add(((RegularFile)this.getRenamesRules().get()).getAsFile().getPath());
        }
        if (this.getVersionsRules().isPresent()) {
            args.add("--versions");
            args.add(((RegularFile)this.getVersionsRules().get()).getAsFile().getPath());
        }
        if (this.getBundlesRules().isPresent()) {
            args.add("--bundles");
            args.add(((RegularFile)this.getBundlesRules().get()).getAsFile().getPath());
        }
        if (this.getDirectRules().isPresent()) {
            args.add("--direct");
            args.add(((RegularFile)this.getDirectRules().get()).getAsFile().getPath());
        }
        if (this.getTextMasterRules().isPresent()) {
            args.add("--text");
            args.add(((RegularFile)this.getTextMasterRules().get()).getAsFile().getPath());
        }
        this.getProject().javaexec(spec -> {
            spec.setClasspath((FileCollection)this.getProject().files(new Object[]{cli.file(String.format("org.eclipse.transformer.cli-%s.jar", this.getVersion().get()))}));
            spec.setArgs((Iterable)args);
        });
    }
}

