/*
 * Decompiled with CFR 0.152.
 */
package io.github.azmaah.eclipse.transformer.task;

import io.github.azmaah.eclipse.transformer.task.BaseTask;
import java.io.File;
import java.util.UUID;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class Setup
extends BaseTask {
    private static final String TASK_DESCRIPTION = "Installs the Eclipse Transformer CLI";
    public static final String TASK_NAME = "setupTransformer";

    public Setup() {
        this.setGroup("transformer");
        this.setDescription(TASK_DESCRIPTION);
    }

    @OutputDirectory
    public Provider<Directory> getOutputDir() {
        return this.cliDir;
    }

    @TaskAction
    public void apply() {
        this.getProject().delete(new Object[]{this.cliDir});
        String configurationName = String.format("cli-%s", UUID.randomUUID());
        String version = (String)this.getVersion().get();
        Configuration cliConfiguration = (Configuration)this.getProject().getConfigurations().create(configurationName);
        cliConfiguration.setTransitive(false);
        this.getProject().getDependencies().add(cliConfiguration.getName(), (Object)String.format("org.eclipse.transformer:%s:%s:distribution", "org.eclipse.transformer.cli", version));
        File installation = cliConfiguration.getSingleFile();
        this.getProject().copy(spec -> {
            spec.from(new Object[]{this.getProject().zipTree((Object)installation)});
            spec.into((Object)this.cliDir);
        });
        this.getProject().getConfigurations().remove((Object)cliConfiguration);
    }
}

