/*
 * Decompiled with CFR 0.152.
 */
package io.github.azmaah.eclipse.transformer;

import io.github.azmaah.eclipse.transformer.TransformerExtension;
import io.github.azmaah.eclipse.transformer.task.BaseTask;
import io.github.azmaah.eclipse.transformer.task.Setup;
import io.github.azmaah.eclipse.transformer.task.Transform;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;

public class TransformerPlugin
implements Plugin<Project> {
    private static final String EXTENSION_NAME = "eclipseTransformer";

    public void apply(Project project) {
        TransformerExtension extension = (TransformerExtension)project.getExtensions().create(EXTENSION_NAME, TransformerExtension.class, new Object[]{project});
        project.getTasks().register("setupTransformer", Setup.class);
        project.getTasks().register("runTransformer", Transform.class);
        project.getTasks().withType(BaseTask.class).configureEach(task -> task.getVersion().set(extension.getVersion()));
        project.getTasks().withType(Transform.class).configureEach(task -> {
            task.getSourceDir().set((Provider)extension.getSourceDir());
            task.getDistDir().set((Provider)extension.getDistDir());
            task.getSelectionRules().set((Provider)extension.getSelectionRules());
            task.getRenamesRules().set((Provider)extension.getRenamesRules());
            task.getVersionsRules().set((Provider)extension.getVersionsRules());
            task.getBundlesRules().set((Provider)extension.getBundlesRules());
            task.getDirectRules().set((Provider)extension.getDirectRules());
            task.getTextMasterRules().set((Provider)extension.getTextMasterRules());
        });
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> project.afterEvaluate(currentProject -> {
            currentProject.getRepositories().flatDir(spec -> spec.dir(extension.getDistDir().get()));
            currentProject.getDependencies().add("implementation", (Object)currentProject.fileTree(extension.getDistDir().get(), f -> f.include(new String[]{"*.jar"})));
            currentProject.getTasks().getByName("compileJava").dependsOn(new Object[]{"runTransformer"});
        }));
    }
}

