/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import io.getunleash.Segment;
import io.getunleash.lang.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SegmentCollection
implements Serializable {
    static final long serialVersionUID = 1214L;
    private final Collection<Segment> segments;
    private final transient Map<Integer, Segment> cache;

    public SegmentCollection(Collection<Segment> segments) {
        this.segments = this.ensureNotNull(segments);
        this.cache = this.segments.size() > 0 ? (Map<Object, Object>)segments.stream().collect(Collectors.toConcurrentMap(Segment::getId, Function.identity())) : new ConcurrentHashMap<Integer, Segment>();
    }

    private Collection<Segment> ensureNotNull(@Nullable Collection<Segment> segments) {
        return Optional.ofNullable(segments).orElseGet(Collections::emptyList);
    }

    public Collection<Segment> getSegments() {
        return Collections.unmodifiableCollection(this.segments);
    }

    public Segment getSegment(Integer id) {
        return this.cache.get(id);
    }
}

