/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.getunleash.repository.FeatureCollection;
import io.getunleash.repository.JsonFeatureSerializer;
import io.getunleash.repository.JsonFeaturesDeserializer;
import java.io.Reader;

final class JsonFeatureParser {
    private JsonFeatureParser() {
    }

    public static String toJsonString(FeatureCollection featureCollection) {
        Gson gson = new GsonBuilder().registerTypeAdapter(FeatureCollection.class, (Object)new JsonFeatureSerializer()).create();
        return gson.toJson((Object)featureCollection);
    }

    public static FeatureCollection fromJson(Reader reader) throws IllegalStateException {
        Gson gson = new GsonBuilder().registerTypeAdapter(FeatureCollection.class, (Object)new JsonFeaturesDeserializer()).create();
        FeatureCollection featureCollection = (FeatureCollection)gson.fromJson(reader, FeatureCollection.class);
        if (featureCollection == null) {
            throw new IllegalStateException("Could not extract features from json");
        }
        return featureCollection;
    }
}

