/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.metric;

import io.getunleash.metric.ClientMetrics;
import io.getunleash.metric.ClientRegistration;
import io.getunleash.metric.MetricSender;
import io.getunleash.metric.MetricsBucket;
import io.getunleash.metric.UnleashMetricService;
import io.getunleash.util.Throttler;
import io.getunleash.util.UnleashConfig;
import io.getunleash.util.UnleashScheduledExecutor;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnleashMetricServiceImpl
implements UnleashMetricService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnleashMetricServiceImpl.class);
    private final LocalDateTime started;
    private final UnleashConfig unleashConfig;
    private final MetricSender metricSender;
    private volatile MetricsBucket currentMetricsBucket = new MetricsBucket();
    private final Throttler throttler;

    public UnleashMetricServiceImpl(UnleashConfig unleashConfig, UnleashScheduledExecutor executor) {
        this(unleashConfig, (MetricSender)unleashConfig.getMetricSenderFactory().apply(unleashConfig), executor);
    }

    public UnleashMetricServiceImpl(UnleashConfig unleashConfig, MetricSender metricSender, UnleashScheduledExecutor executor) {
        this.started = LocalDateTime.now(ZoneId.of("UTC"));
        this.unleashConfig = unleashConfig;
        this.metricSender = metricSender;
        this.throttler = new Throttler((int)unleashConfig.getSendMetricsInterval(), 300, unleashConfig.getUnleashURLs().getClientMetricsURL());
        long metricsInterval = unleashConfig.getSendMetricsInterval();
        executor.setInterval(this.sendMetrics(), metricsInterval, metricsInterval);
    }

    @Override
    public void register(Set<String> strategies) {
        ClientRegistration registration = new ClientRegistration(this.unleashConfig, this.started, strategies);
        this.metricSender.registerClient(registration);
    }

    @Override
    public void count(String toggleName, boolean active) {
        this.currentMetricsBucket.registerCount(toggleName, active);
    }

    @Override
    public void countVariant(String toggleName, String variantName) {
        this.currentMetricsBucket.registerCount(toggleName, variantName);
    }

    private Runnable sendMetrics() {
        return () -> {
            if (this.throttler.performAction()) {
                MetricsBucket metricsBucket = this.currentMetricsBucket;
                this.currentMetricsBucket = new MetricsBucket();
                metricsBucket.end();
                ClientMetrics metrics = new ClientMetrics(this.unleashConfig, metricsBucket);
                int statusCode = this.metricSender.sendMetrics(metrics);
                if (statusCode >= 200 && statusCode < 400) {
                    this.throttler.decrementFailureCountAndResetSkips();
                }
                if (statusCode >= 400) {
                    this.throttler.handleHttpErrorCodes(statusCode);
                }
            } else {
                this.throttler.skipped();
            }
        };
    }

    protected int getSkips() {
        return this.throttler.getSkips();
    }

    protected int getFailures() {
        return this.throttler.getFailures();
    }
}

