/*
 * Decompiled with CFR 0.152.
 */
package org.unleash.features.config;

import io.getunleash.DefaultUnleash;
import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import io.getunleash.UnleashContextProvider;
import io.getunleash.repository.OkHttpFeatureFetcher;
import io.getunleash.strategy.Strategy;
import io.getunleash.util.UnleashConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.unleash.features.aop.UnleashContextThreadLocal;
import org.unleash.features.aop.Utils;
import org.unleash.features.autoconfigure.UnleashProperties;

@EnableConfigurationProperties(value={UnleashProperties.class})
@AutoConfiguration
@ComponentScan(value={"org.unleash.features.aop"})
public class UnleashAutoConfiguration {
    @Autowired(required=false)
    private Map<String, ? extends Strategy> strategyMap;

    @Bean
    @ConditionalOnMissingBean
    public UnleashContextProvider unleashContextProvider(UnleashProperties unleashProperties) {
        return () -> UnleashContext.builder().appName(unleashProperties.getAppName()).environment(unleashProperties.getEnvironment()).build();
    }

    @Bean
    public Unleash unleash(UnleashProperties unleashProperties, UnleashContextProvider unleashContextProvider) {
        UnleashContextProvider provider = this.getUnleashContextProviderWithThreadLocalSupport(unleashContextProvider);
        UnleashConfig.Builder builder = UnleashConfig.builder().unleashContextProvider(provider).appName(unleashProperties.getAppName()).environment(unleashProperties.getEnvironment()).unleashAPI(unleashProperties.getApiUrl()).fetchTogglesConnectTimeout(unleashProperties.getFetchTogglesConnectTimeout()).fetchTogglesReadTimeout(unleashProperties.getFetchTogglesReadTimeout()).fetchTogglesInterval(unleashProperties.getFetchTogglesInterval().getSeconds()).sendMetricsInterval(unleashProperties.getSendMetricsInterval().getSeconds()).sendMetricsConnectTimeout(unleashProperties.getSendMetricsConnectTimeout()).sendMetricsReadTimeout(unleashProperties.getSendMetricsReadTimeout()).customHttpHeader("Authorization", unleashProperties.getApiToken()).projectName(unleashProperties.getProjectName()).synchronousFetchOnInitialisation(unleashProperties.isSynchronousFetchOnInitialisation()).instanceId(StringUtils.hasText((String)unleashProperties.getInstanceId()) ? unleashProperties.getInstanceId() : UUID.randomUUID().toString());
        this.setDisableMetrics(builder, unleashProperties);
        this.setHttpFetcherInBuilder(builder, unleashProperties);
        this.setProxyAuthenticationByJvmProps(builder, unleashProperties);
        this.setCustomHeaderProvider(builder, unleashProperties);
        return !CollectionUtils.isEmpty(this.strategyMap) ? new DefaultUnleash(builder.build(), this.strategyMap.values().toArray(new Strategy[0])) : new DefaultUnleash(builder.build(), new Strategy[0]);
    }

    @NotNull
    private UnleashContextProvider getUnleashContextProviderWithThreadLocalSupport(UnleashContextProvider unleashContextProvider) {
        return () -> {
            Map threadLocalContextMap = UnleashContextThreadLocal.getContextMap();
            if (CollectionUtils.isEmpty((Map)threadLocalContextMap)) {
                return unleashContextProvider.getContext();
            }
            UnleashContext context = unleashContextProvider.getContext();
            UnleashContext.Builder builder = UnleashContext.builder();
            HashMap<String, String> currentContextMap = new HashMap<String, String>(context.getProperties() != null ? context.getProperties() : Collections.emptyMap());
            currentContextMap.putAll(threadLocalContextMap);
            context.getAppName().ifPresent(arg_0 -> ((UnleashContext.Builder)builder).appName(arg_0));
            context.getEnvironment().ifPresent(arg_0 -> ((UnleashContext.Builder)builder).environment(arg_0));
            context.getCurrentTime().ifPresent(arg_0 -> ((UnleashContext.Builder)builder).currentTime(arg_0));
            context.getRemoteAddress().ifPresent(arg_0 -> ((UnleashContext.Builder)builder).remoteAddress(arg_0));
            context.getSessionId().ifPresent(arg_0 -> ((UnleashContext.Builder)builder).sessionId(arg_0));
            currentContextMap.forEach((key, value) -> Utils.setContextBuilderProperty((UnleashContext.Builder)builder, (String)key, (String)value));
            return builder.build();
        };
    }

    private UnleashConfig.Builder setHttpFetcherInBuilder(UnleashConfig.Builder builder, UnleashProperties unleashProperties) {
        if (unleashProperties.getHttpFetcher() == UnleashProperties.HttpFetcher.HTTP_URL_CONNECTION_FETCHER) {
            return builder;
        }
        return builder.unleashFeatureFetcherFactory(OkHttpFeatureFetcher::new);
    }

    private UnleashConfig.Builder setProxyAuthenticationByJvmProps(UnleashConfig.Builder builder, UnleashProperties properties) {
        return properties.isProxyAuthenticationByJvmProperties() ? builder.enableProxyAuthenticationByJvmProperties() : builder;
    }

    private UnleashConfig.Builder setCustomHeaderProvider(UnleashConfig.Builder builder, UnleashProperties properties) {
        return !CollectionUtils.isEmpty(properties.getCustomHttpHeadersProvider()) ? builder.customHttpHeadersProvider(() -> properties.getCustomHttpHeadersProvider().stream().collect(Collectors.toMap(UnleashProperties.CustomHeader::getName, UnleashProperties.CustomHeader::getValue))) : builder;
    }

    private UnleashConfig.Builder setDisableMetrics(UnleashConfig.Builder builder, UnleashProperties properties) {
        return properties.isDisableMetrics() ? builder.disableMetrics() : builder;
    }
}

