/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.wavelet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastWaveletTransform {
    private static final Logger LOGGER = LoggerFactory.getLogger(FastWaveletTransform.class);
    static final double[] scale = new double[]{0.0322231f, -0.01260396745055914, -0.09921954572200775, 0.2978578f, 0.8037387728691101, 0.4976186752319336, -0.029635528102517128, -0.0757657140493393};
    static final double[] wavelet = new double[]{-scale[7], scale[6], -scale[5], scale[4], -scale[3], scale[2], -scale[1], scale[0]};

    private FastWaveletTransform() {
    }

    public static void invTransform(double[] v) {
        int last = 8;
        while (2 * last <= v.length) {
            FastWaveletTransform.invTransform(v, last);
            last *= 2;
        }
        if (last != v.length) {
            LOGGER.atWarn().addArgument((Object)v.length).log("Careful! this should be a power of 2 : {}");
        }
    }

    public static void transform(double[] v) {
        int last;
        for (last = v.length; last > 8; last /= 2) {
            FastWaveletTransform.transform(v, last);
        }
        if (last != 8) {
            LOGGER.atWarn().addArgument((Object)v.length).log("Careful! this should be a power of 2 : {}");
        }
    }

    public static void invTransform(double[] v, int n) {
        int ResultingLength = n << 1;
        double[] ans = new double[ResultingLength];
        try {
            for (int k = 0; k < v.length / 2 - scale.length; ++k) {
                for (int i = wavelet.length - 1; i >= 0; --i) {
                    int n2 = 2 * k + i;
                    ans[n2] = ans[n2] + (scale[i] * v[k] + wavelet[i] * v[k + n]);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.atWarn().addArgument((Object)n).setCause((Throwable)e).log("exception {}  message:");
        }
        int n3 = ResultingLength - 6;
        ans[n3] = ans[n3] + (scale[0] * v[n - 3] + wavelet[0] * v[ResultingLength - 3]);
        int n4 = ResultingLength - 5;
        ans[n4] = ans[n4] + (scale[1] * v[n - 3] + wavelet[1] * v[ResultingLength - 3]);
        int n5 = ResultingLength - 4;
        ans[n5] = ans[n5] + (scale[2] * v[n - 3] + wavelet[2] * v[ResultingLength - 3]);
        int n6 = ResultingLength - 3;
        ans[n6] = ans[n6] + (scale[3] * v[n - 3] + wavelet[3] * v[ResultingLength - 3]);
        int n7 = ResultingLength - 2;
        ans[n7] = ans[n7] + (scale[4] * v[n - 3] + wavelet[4] * v[ResultingLength - 3]);
        int n8 = ResultingLength - 1;
        ans[n8] = ans[n8] + (scale[5] * v[n - 3] + wavelet[5] * v[ResultingLength - 3]);
        ans[0] = ans[0] + (scale[6] * v[n - 3] + wavelet[6] * v[ResultingLength - 3]);
        ans[1] = ans[1] + (scale[7] * v[n - 3] + wavelet[7] * v[ResultingLength - 3]);
        int n9 = ResultingLength - 4;
        ans[n9] = ans[n9] + (scale[0] * v[n - 2] + wavelet[0] * v[ResultingLength - 2]);
        int n10 = ResultingLength - 3;
        ans[n10] = ans[n10] + (scale[1] * v[n - 2] + wavelet[1] * v[ResultingLength - 2]);
        int n11 = ResultingLength - 2;
        ans[n11] = ans[n11] + (scale[2] * v[n - 2] + wavelet[2] * v[ResultingLength - 2]);
        int n12 = ResultingLength - 1;
        ans[n12] = ans[n12] + (scale[3] * v[n - 2] + wavelet[3] * v[ResultingLength - 2]);
        ans[0] = ans[0] + (scale[4] * v[n - 2] + wavelet[4] * v[ResultingLength - 2]);
        ans[1] = ans[1] + (scale[5] * v[n - 2] + wavelet[5] * v[ResultingLength - 2]);
        ans[2] = ans[2] + (scale[6] * v[n - 2] + wavelet[6] * v[ResultingLength - 2]);
        ans[3] = ans[3] + (scale[7] * v[n - 2] + wavelet[7] * v[ResultingLength - 2]);
        int n13 = ResultingLength - 2;
        ans[n13] = ans[n13] + (scale[0] * v[n - 1] + wavelet[0] * v[ResultingLength - 1]);
        int n14 = ResultingLength - 1;
        ans[n14] = ans[n14] + (scale[1] * v[n - 1] + wavelet[1] * v[ResultingLength - 1]);
        ans[0] = ans[0] + (scale[2] * v[n - 1] + wavelet[2] * v[ResultingLength - 1]);
        ans[1] = ans[1] + (scale[3] * v[n - 1] + wavelet[3] * v[ResultingLength - 1]);
        ans[2] = ans[2] + (scale[4] * v[n - 1] + wavelet[4] * v[ResultingLength - 1]);
        ans[3] = ans[3] + (scale[5] * v[n - 1] + wavelet[5] * v[ResultingLength - 1]);
        ans[4] = ans[4] + (scale[6] * v[n - 1] + wavelet[6] * v[ResultingLength - 1]);
        ans[5] = ans[5] + (scale[7] * v[n - 1] + wavelet[7] * v[ResultingLength - 1]);
        System.arraycopy(ans, 0, v, 0, ans.length);
    }

    public static int mirror(int i, int n) {
        if (i < n) {
            return i;
        }
        return 2 * n - i;
    }

    public static void transform(double[] data, int n) {
        double[] ans = new double[n];
        int half = n >> 1;
        try {
            for (int k = 0; k < half; ++k) {
                for (int i = 0; i < wavelet.length; ++i) {
                    double a = data[FastWaveletTransform.mirror(2 * k + i, data.length)] * wavelet[i];
                    double b = data[FastWaveletTransform.mirror(2 * k + i, data.length)] * scale[i];
                    int n2 = k + half;
                    ans[n2] = ans[n2] + a;
                    int n3 = k;
                    ans[n3] = ans[n3] + b;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.atWarn().addArgument((Object)n).setCause((Throwable)e).log("exception {}  message:");
        }
        System.arraycopy(ans, 0, data, 0, n);
    }
}

