/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.wavelet;

public class CDFWavelet {
    public void fwt53(double[] x, int n) {
        int i;
        double a = -0.5;
        for (i = 1; i < n - 2; i += 2) {
            int n2 = i;
            x[n2] = x[n2] + a * (x[i - 1] + x[i + 1]);
        }
        int n3 = n - 1;
        x[n3] = x[n3] + 2.0 * a * x[n - 2];
        a = 0.25;
        for (i = 2; i < n; i += 2) {
            int n4 = i;
            x[n4] = x[n4] + a * (x[i - 1] + x[i + 1]);
        }
        x[0] = x[0] + 2.0 * a * x[1];
        a = Math.sqrt(2.0);
        for (i = 0; i < n; ++i) {
            if (i % 2 > 0) {
                int n5 = i;
                x[n5] = x[n5] * a;
                continue;
            }
            int n6 = i;
            x[n6] = x[n6] / a;
        }
        double[] tempbank = null;
        if (tempbank == null) {
            tempbank = new double[n];
        }
        for (i = 0; i < n; ++i) {
            if (i % 2 == 0) {
                tempbank[i / 2] = x[i];
                continue;
            }
            tempbank[n / 2 + i / 2] = x[i];
        }
        for (i = 0; i < n; ++i) {
            x[i] = tempbank[i];
        }
    }

    public void fwt97(double[] x, int n) {
        int i;
        double a = -1.586134342;
        for (i = 1; i < n - 2; i += 2) {
            int n2 = i;
            x[n2] = x[n2] + a * (x[i - 1] + x[i + 1]);
        }
        int n3 = n - 1;
        x[n3] = x[n3] + 2.0 * a * x[n - 2];
        a = -0.05298011854;
        for (i = 2; i < n; i += 2) {
            int n4 = i;
            x[n4] = x[n4] + a * (x[i - 1] + x[i + 1]);
        }
        x[0] = x[0] + 2.0 * a * x[1];
        a = 0.8829110762;
        for (i = 1; i < n - 2; i += 2) {
            int n5 = i;
            x[n5] = x[n5] + a * (x[i - 1] + x[i + 1]);
        }
        int n6 = n - 1;
        x[n6] = x[n6] + 2.0 * a * x[n - 2];
        a = 0.4435068522;
        for (i = 2; i < n; i += 2) {
            int n7 = i;
            x[n7] = x[n7] + a * (x[i - 1] + x[i + 1]);
        }
        x[0] = x[0] + 2.0 * a * x[1];
        a = 0.869864452275695;
        for (i = 0; i < n; ++i) {
            if (i % 2 > 0) {
                int n8 = i;
                x[n8] = x[n8] * a;
                continue;
            }
            int n9 = i;
            x[n9] = x[n9] / a;
        }
        double[] tempbank = null;
        if (tempbank == null) {
            tempbank = new double[n];
        }
        for (i = 0; i < n; ++i) {
            if (i % 2 == 0) {
                tempbank[i / 2] = x[i];
                continue;
            }
            tempbank[n / 2 + i / 2] = x[i];
        }
        for (i = 0; i < n; ++i) {
            x[i] = tempbank[i];
        }
    }

    public void iwt53(double[] x, int n) {
        int i;
        double[] tempbank = null;
        if (tempbank == null) {
            tempbank = new double[n];
        }
        for (i = 0; i < n / 2; ++i) {
            tempbank[i * 2] = x[i];
            tempbank[i * 2 + 1] = x[i + n / 2];
        }
        for (i = 0; i < n; ++i) {
            x[i] = tempbank[i];
        }
        double a = 1.0 / Math.sqrt(2.0);
        for (i = 0; i < n; ++i) {
            if (i % 2 > 0) {
                int n2 = i;
                x[n2] = x[n2] * a;
                continue;
            }
            int n3 = i;
            x[n3] = x[n3] / a;
        }
        a = -0.25;
        for (i = 2; i < n; i += 2) {
            int n4 = i;
            x[n4] = x[n4] + a * (x[i - 1] + x[i + 1]);
        }
        x[0] = x[0] + 2.0 * a * x[1];
        a = 0.5;
        for (i = 1; i < n - 2; i += 2) {
            int n5 = i;
            x[n5] = x[n5] + a * (x[i - 1] + x[i + 1]);
        }
        int n6 = n - 1;
        x[n6] = x[n6] + 2.0 * a * x[n - 2];
    }

    public void iwt97(double[] x, int n) {
        int i;
        double[] tempbank = null;
        if (tempbank == null) {
            tempbank = new double[n];
        }
        for (i = 0; i < n / 2; ++i) {
            tempbank[i * 2] = x[i];
            tempbank[i * 2 + 1] = x[i + n / 2];
        }
        for (i = 0; i < n; ++i) {
            x[i] = tempbank[i];
        }
        double a = 1.149604398;
        for (i = 0; i < n; ++i) {
            if (i % 2 > 0) {
                int n2 = i;
                x[n2] = x[n2] * a;
                continue;
            }
            int n3 = i;
            x[n3] = x[n3] / a;
        }
        a = -0.4435068522;
        for (i = 2; i < n; i += 2) {
            int n4 = i;
            x[n4] = x[n4] + a * (x[i - 1] + x[i + 1]);
        }
        x[0] = x[0] + 2.0 * a * x[1];
        a = -0.8829110762;
        for (i = 1; i < n - 2; i += 2) {
            int n5 = i;
            x[n5] = x[n5] + a * (x[i - 1] + x[i + 1]);
        }
        int n6 = n - 1;
        x[n6] = x[n6] + 2.0 * a * x[n - 2];
        a = 0.05298011854;
        for (i = 2; i < n; i += 2) {
            int n7 = i;
            x[n7] = x[n7] + a * (x[i - 1] + x[i + 1]);
        }
        x[0] = x[0] + 2.0 * a * x[1];
        a = 1.586134342;
        for (i = 1; i < n - 2; i += 2) {
            int n8 = i;
            x[n8] = x[n8] + a * (x[i - 1] + x[i + 1]);
        }
        int n9 = n - 1;
        x[n9] = x[n9] + 2.0 * a * x[n - 2];
    }

    public static void main(String[] argv) {
        int i;
        CDFWavelet wtf = new CDFWavelet();
        double[] x = new double[32];
        for (i = 0; i < 32; ++i) {
            x[i] = (double)(5 + i) + 0.4 * (double)i * (double)i - 0.02 * (double)i * (double)i * (double)i;
        }
        System.out.print("Original signal:\n");
        for (i = 0; i < 32; ++i) {
            System.out.printf("x[%d]=%f\n", i, x[i]);
        }
        System.out.print("\n");
        wtf.fwt97(x, 32);
        System.out.print("Wavelets coefficients:\n");
        for (i = 0; i < 32; ++i) {
            System.out.printf("wc[%d]=%f\n", i, x[i]);
        }
        System.out.print("\n");
        wtf.iwt97(x, 32);
        System.out.print("Reconstructed signal:\n");
        for (i = 0; i < 32; ++i) {
            System.out.printf("xx[%d]=%f\n", i, x[i]);
        }
    }
}

