/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.matrix;

import io.fair_acc.math.MathBase;
import io.fair_acc.math.functions.Function1D;
import io.fair_acc.math.matrix.AbstractMatrix;
import io.fair_acc.math.matrix.CholeskyDecomposition;
import io.fair_acc.math.matrix.EigenvalueDecomposition;
import io.fair_acc.math.matrix.LUDecomposition;
import io.fair_acc.math.matrix.MatrixFactory;
import io.fair_acc.math.matrix.QRDecomposition;
import io.fair_acc.math.matrix.SingularValueDecomposition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class MatrixD
extends AbstractMatrix {
    private static final long serialVersionUID = 491870425070247870L;
    private final double[][] element;

    public MatrixD(double[] vals, int m) {
        this(vals, m, true);
    }

    public MatrixD(double[] vals, int m, boolean rowMajor) {
        this.m = m;
        int n = this.n = m != 0 ? vals.length / m : 0;
        if (m * this.n != vals.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.element = new double[m][this.n];
        if (rowMajor) {
            for (int i = 0; i < m; ++i) {
                System.arraycopy(vals, i * this.n, this.element[i], 0, this.n);
            }
        } else {
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.element[i][j] = vals[i + j * m];
                }
            }
        }
    }

    public MatrixD(double[][] A) {
        this.m = A.length;
        this.n = A[0].length;
        for (int i = 0; i < this.m; ++i) {
            if (A[i].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.element = A;
    }

    public MatrixD(double[][] A, int m, int n) {
        this.element = A;
        this.m = m;
        this.n = n;
    }

    public MatrixD(int m, int n) {
        this.m = m;
        this.n = n;
        this.element = new double[m][n];
    }

    public MatrixD(int m, int n, double s) {
        this.m = m;
        this.n = n;
        this.element = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.element[i][j] = s;
            }
        }
    }

    public void apply1DFunction(Function1D func) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.element[i][j] = func.getValue(this.element[i][j]);
            }
        }
    }

    public MatrixD arrayLeftDivide(MatrixD B) {
        this.checkMatrixDimensions(B);
        MatrixD X = new MatrixD(this.m, this.n);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = B.element[i][j] / this.element[i][j];
            }
        }
        return X;
    }

    public MatrixD arrayLeftDivideEquals(MatrixD B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.element[i][j] = B.element[i][j] / this.element[i][j];
            }
        }
        return this;
    }

    public MatrixD arrayRightDivide(MatrixD B) {
        this.checkMatrixDimensions(B);
        MatrixD X = new MatrixD(this.m, this.n);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                X.set(i, j, this.get(i, j) / B.get(i, j));
            }
        }
        return X;
    }

    public MatrixD arrayRightDivideEquals(MatrixD B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.element[i][j] = this.element[i][j] / B.element[i][j];
            }
        }
        return this;
    }

    public MatrixD arrayTimes(MatrixD B) {
        this.checkMatrixDimensions(B);
        MatrixD X = new MatrixD(this.m, this.n);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.element[i][j] * B.element[i][j];
            }
        }
        return X;
    }

    public MatrixD arrayTimesEquals(MatrixD B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i, j) * B.get(i, j));
            }
        }
        return this;
    }

    public CholeskyDecomposition chol() {
        return new CholeskyDecomposition(this);
    }

    public Object clone() {
        return this.copy();
    }

    public double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    @Override
    public MatrixD copy() {
        MatrixD X = new MatrixD(this.m, this.n);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            if (this.n < 0) continue;
            System.arraycopy(this.element[i], 0, C[i], 0, this.n);
        }
        return X;
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    @Override
    public double get(int i, int j) {
        return this.element[i][j];
    }

    public double[][] getArray() {
        return this.element;
    }

    public double[][] getArrayCopy() {
        double[][] C = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            System.arraycopy(this.element[i], 0, C[i], 0, this.n);
        }
        return C;
    }

    public double[] getColumnPackedCopy() {
        double[] vals = new double[this.m * this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                vals[i + j * this.m] = this.element[i][j];
            }
        }
        return vals;
    }

    public MatrixD getMatrix(int i0, int i1, int j0, int j1) {
        MatrixD X = new MatrixD(i1 - i0 + 1, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            for (int i = i0; i <= i1; ++i) {
                System.arraycopy(this.element[i], j0, B[i - i0], j0, j1 - j0);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public MatrixD getMatrix(int i0, int i1, int[] c) {
        MatrixD X = new MatrixD(i1 - i0 + 1, c.length);
        double[][] B = X.getArray();
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    B[i - i0][j] = this.element[i][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public MatrixD getMatrix(int[] r, int j0, int j1) {
        MatrixD X = new MatrixD(r.length, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            for (int i = 0; i < r.length; ++i) {
                if (j1 + 1 - j0 < 0) continue;
                System.arraycopy(this.element[r[i]], j0, B[i], j0 - j0, j1 + 1 - j0);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public MatrixD getMatrix(int[] r, int[] c) {
        MatrixD X = new MatrixD(r.length, c.length);
        double[][] B = X.getArray();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    B[i][j] = this.element[r[i]][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public double[] getRowPackedCopy() {
        double[] vals = new double[this.m * this.n];
        for (int i = 0; i < this.m; ++i) {
            System.arraycopy(this.element[i], 0, vals, i * this.m, this.n);
        }
        return vals;
    }

    public MatrixD inverse() {
        return this.solve(MatrixFactory.identity(this.m, this.m));
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public MatrixD minus(MatrixD B) {
        this.checkMatrixDimensions(B);
        MatrixD X = new MatrixD(this.m, this.n);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = this.element[i][j] - B.element[i][j];
            }
        }
        return X;
    }

    public MatrixD minusEquals(MatrixD B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.element[i][j] = this.element[i][j] - B.element[i][j];
            }
        }
        return this;
    }

    public MatrixD plus(MatrixD B) {
        this.checkMatrixDimensions(B);
        MatrixD X = new MatrixD(this.m, this.n);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                X.set(i, j, this.get(i, j) + B.get(i, j));
            }
        }
        return X;
    }

    public MatrixD plusEquals(MatrixD B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.set(i, j, this.get(i, j) + B.get(i, j));
            }
        }
        return this;
    }

    public void print(int w, int d) {
        this.print(new PrintWriter(System.out, true), w, d);
    }

    public void print(NumberFormat format, int width) {
        this.print(new PrintWriter(System.out, true), format, width);
    }

    public void print(PrintWriter output, int w, int d) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        this.print(output, format, w + 2);
    }

    public void print(PrintWriter output, NumberFormat format, int width) {
        output.println();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                String s = format.format(this.element[i][j]);
                int padding = Math.max(1, width - s.length());
                for (int k = 0; k < padding; ++k) {
                    output.print(' ');
                }
                output.print(s);
            }
            output.println();
        }
        output.println();
    }

    public MatrixD pseudoInverse(double condition) {
        SingularValueDecomposition decomp = this.svd();
        double invCondition = condition > 0.0 ? 1.0 / condition : 1.0E19;
        double[] sig = decomp.getSingularValues();
        MatrixD newS = new MatrixD(sig.length, sig.length);
        double first = sig[0];
        for (int i = 0; i < sig.length; ++i) {
            if (sig[i] / first < invCondition || MathBase.abs(sig[i]) < 9.9E-324) {
                System.out.println("TMatrixD::drop singluar eigenvalue " + i);
                newS.set(i, i, 0.0);
                continue;
            }
            newS.set(i, i, 1.0 / sig[i]);
        }
        decomp.rank();
        return decomp.getV().times(newS).times(decomp.getU().transpose());
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    @Override
    public void set(int i, int j, double s) {
        this.element[i][j] = s;
    }

    public void setMatrix(int i0, int i1, int j0, int j1, MatrixD X) {
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    this.element[i][j] = X.get(i - i0, j - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int i0, int i1, int[] c, MatrixD X) {
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    this.element[i][c[j]] = X.get(i - i0, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int j0, int j1, MatrixD X) {
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    this.element[r[i]][j] = X.get(i, j - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int[] c, MatrixD X) {
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    this.element[r[i]][c[j]] = X.get(i, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public MatrixD solve(MatrixD B) {
        return this.m == this.n ? new LUDecomposition(this).solve(B) : new QRDecomposition(this).solve(B);
    }

    public MatrixD solveTranspose(MatrixD B) {
        return this.transpose().solve(B.transpose());
    }

    public void squareElements() {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.element[i][j] = MathBase.sqr(this.element[i][j]);
            }
        }
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public MatrixD times(double s) {
        MatrixD X = new MatrixD(this.m, this.n);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[i][j] = s * this.element[i][j];
            }
        }
        return X;
    }

    public MatrixD times(MatrixD B) {
        if (B.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        MatrixD X = new MatrixD(this.m, B.n);
        double[][] C = X.getArray();
        double[] vector = new double[this.n];
        if (B.n != 1) {
            for (int j = 0; j < B.n; ++j) {
                for (int k = 0; k < this.n; ++k) {
                    vector[k] = B.element[k][j];
                }
                for (int i = 0; i < this.m; ++i) {
                    double[] Arowi = this.element[i];
                    double s = 0.0;
                    for (int k = 0; k < this.n; ++k) {
                        s += Arowi[k] * vector[k];
                    }
                    C[i][j] = s;
                }
            }
        } else {
            int i;
            for (i = 0; i < this.n; ++i) {
                vector[i] = B.element[i][0];
            }
            for (i = 0; i < this.m; ++i) {
                double val = 0.0;
                for (int j = 0; j < this.n; ++j) {
                    val += this.element[i][j] * vector[j];
                }
                C[i][0] = val;
            }
        }
        return X;
    }

    public MatrixD timesEquals(double s) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.element[i][j] = s * this.element[i][j];
            }
        }
        return this;
    }

    public double trace() {
        double t = 0.0;
        for (int i = 0; i < Math.min(this.m, this.n); ++i) {
            t += this.element[i][i];
        }
        return t;
    }

    public MatrixD transpose() {
        MatrixD X = new MatrixD(this.n, this.m);
        double[][] C = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                C[j][i] = this.element[i][j];
            }
        }
        return X;
    }

    public MatrixD uminus() {
        MatrixD X = new MatrixD(this.m, this.n);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                X.set(i, j, -this.element[i][j]);
            }
        }
        return X;
    }

    public static MatrixD read(BufferedReader input) throws IOException {
        int j;
        StreamTokenizer tokenizer = new StreamTokenizer(input);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(true);
        Vector<Double> v = new Vector<Double>();
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            v.addElement(Double.valueOf(tokenizer.sval));
        } while (tokenizer.nextToken() == -3);
        int n = v.size();
        Double[] row = new Double[n];
        v.removeAllElements();
        for (j = 0; j < n; ++j) {
            v.addElement((Double)v.elementAt(j));
        }
        while (tokenizer.nextToken() == -3) {
            j = 0;
            do {
                if (j >= n) {
                    throw new IOException("Row " + v.size() + " is too long.");
                }
                v.addElement(Double.valueOf(tokenizer.sval));
            } while (tokenizer.nextToken() == -3);
            if (j >= n) continue;
            throw new IOException("Row " + v.size() + " is too short.");
        }
        int m = v.size();
        double[][] A = new double[m][];
        v.copyInto((Object[])A);
        return new MatrixD(A);
    }
}

