/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.matrix;

import io.fair_acc.math.matrix.Matrix;
import io.fair_acc.math.matrix.MatrixD;
import io.fair_acc.math.matrix.SingularValueDecomposition;

public abstract class AbstractMatrix
implements Matrix {
    private static final long serialVersionUID = 4161055769254544900L;
    protected int m;
    protected int n;

    @Override
    public void checkMatrixDimensions(Matrix B) {
        if (B.getRowDimension() != this.m || B.getColumnDimension() != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }

    @Override
    public int getColumnDimension() {
        return this.n;
    }

    @Override
    public int getRowDimension() {
        return this.m;
    }

    public double norm1() {
        double f = 0.0;
        for (int j = 0; j < this.n; ++j) {
            double s = 0.0;
            for (int i = 0; i < this.m; ++i) {
                s += Math.abs(this.get(i, j));
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public double norm2() {
        if (this instanceof MatrixD) {
            return new SingularValueDecomposition((MatrixD)this).norm2();
        }
        MatrixD temp = new MatrixD(this.getRowDimension(), this.getColumnDimension());
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                temp.set(i, j, this.get(i, j));
            }
        }
        return new SingularValueDecomposition(temp).norm2();
    }

    public double normF() {
        double f = 0.0;
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                f = Math.hypot(f, this.get(i, j));
            }
        }
        return f;
    }

    public double normInf() {
        double f = 0.0;
        for (int i = 0; i < this.m; ++i) {
            double s = 0.0;
            for (int j = 0; j < this.n; ++j) {
                s += Math.abs(this.get(i, j));
            }
            f = Math.max(f, s);
        }
        return f;
    }
}

