/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.functions;

import io.fair_acc.math.Math;
import io.fair_acc.math.functions.AbstractFunction1D;
import io.fair_acc.math.functions.Function1D;

public class LogNormalFunction
extends AbstractFunction1D
implements Function1D {
    public LogNormalFunction(String name) {
        this(name, null);
    }

    public LogNormalFunction(String name, double[] parameter) {
        super(name, new double[3]);
        this.setParameterName(0, "theta");
        this.setParameterValue(0, 0.0);
        this.setParameterName(1, "sigma");
        this.setParameterValue(1, 1.0);
        this.setParameterName(2, "scaling");
        this.setParameterValue(2, 1.0);
        if (parameter == null) {
            return;
        }
        for (int i = 0; i < Math.min(parameter.length, 3); ++i) {
            this.setParameterValue(i, parameter[i]);
        }
    }

    @Override
    public double getValue(double x) {
        return Math.logNormal(x, this.fparameter[0], this.fparameter[1], this.fparameter[2]);
    }
}

