/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.functions;

import io.fair_acc.math.MathBase;
import io.fair_acc.math.functions.AbstractFunction1D;

public class CombFunction
extends AbstractFunction1D {
    public CombFunction(String name, double[] parameter) {
        super(name, new double[3]);
        this.setParameterName(0, "fundamental");
        this.setParameterName(1, "scale");
        this.setParameterName(2, "width");
        if (parameter == null) {
            return;
        }
        int maxIndex = MathBase.min(parameter.length, this.getParameterCount());
        for (int i = 0; i < maxIndex; ++i) {
            this.setParameterValue(i, parameter[i]);
        }
    }

    @Override
    public double getValue(double x) {
        double y = 0.0;
        double fundamental = this.fparameter[0];
        if (fundamental == 0.0) {
            return 0.0;
        }
        for (int i = 1; i < 1024; ++i) {
            if (!(Math.abs((double)i * fundamental - x) < this.fparameter[2])) continue;
            y += 1.0;
        }
        return this.fparameter[1] * y;
    }
}

