/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.fitter;

public class GaussFitting {
    private static double fmean = 1.0;
    private static double fmeanError = 0.0;
    private static double frms = 1.0;
    private static double frmsError = 0.0;
    private static double farea = 0.0;
    private static double fareaError = 0.0;
    private static double fconstant = 1.0;
    private static double fconstantError = 1.0;

    public static void fitData(double[] sliceX, double[] sliceY, double meanEstimate, double sigma, double nSigma) {
        int i;
        int tmin = 0;
        int tmax = sliceX.length - 1;
        int center = (int)meanEstimate;
        int nadd = 100;
        int halfWidth = (int)(nSigma * sigma);
        if (center - tmin < halfWidth) {
            halfWidth = center - tmin;
        }
        if (tmax - center < halfWidth) {
            halfWidth = tmax - center;
        }
        double x = 0.0;
        double x2 = 0.0;
        double norm = 0.0;
        double dx = sliceX[1] - sliceX[0];
        double area = 0.0;
        double eqArea = 0.0;
        double[] pos = new double[2 * halfWidth + 2 * nadd];
        double[] meas = new double[2 * halfWidth + 2 * nadd];
        double[] var = new double[2 * halfWidth + 2 * nadd];
        for (i = 0; i < 2 * halfWidth; ++i) {
            double valX = sliceX[center - halfWidth + i];
            double valY = sliceY[center - halfWidth + i];
            pos[i + nadd] = valX;
            meas[i + nadd] = valY;
        }
        for (i = 0; i < nadd; ++i) {
            pos[nadd - i] = pos[nadd] - dx * (double)i;
            pos[nadd + 2 * halfWidth + i] = pos[nadd + 2 * halfWidth - 1] + dx * (double)i;
            meas[i] = 0.0;
            meas[nadd + 2 * halfWidth + i] = 0.0;
        }
        for (i = 0; i < meas.length; ++i) {
            var[i] = Math.pow(meas[i] * 0.1, 2.0);
            norm += meas[i];
            x += meas[i] * pos[i];
            x2 += meas[i] * pos[i] * pos[i];
            area += dx * meas[i];
            eqArea += meas[i];
        }
        double mean = x / norm;
        double rms2 = x2 / norm - mean * mean;
        double rms = rms2 > 0.0 ? Math.sqrt(rms2) : 1.0;
        fmean = mean;
        frms = rms;
        fconstant = area;
        farea = eqArea;
    }

    public static double getArea() {
        return farea;
    }

    public static double getAreaError() {
        return fareaError;
    }

    public static double getConstant() {
        return fconstant;
    }

    public static double getConstantError() {
        return fconstantError;
    }

    public static double getMean() {
        return fmean;
    }

    public static double getMeanError() {
        return fmeanError;
    }

    public static double getRMS() {
        return frms;
    }

    public static double getRMSError() {
        return frmsError;
    }

    public static void main(String[] args) {
        int n = 100;
        double[] valX = new double[n];
        double[] valY = new double[n];
        double mu = 3.0;
        double sigma = 0.5;
        for (int i = 0; i < n; ++i) {
            valX[i] = 0.1 * (double)i;
            valY[i] = Math.exp(-0.5 * Math.pow((valX[i] - mu) / sigma, 2.0)) / (Math.sqrt(Math.PI * 2) * sigma);
        }
        GaussFitting.fitData(valX, valY, 40.0, 20.0, 20.0);
        GaussFitting.print();
    }

    public static void print() {
        System.out.printf("mean    : %s \t+- %s%nrms     : %s \t+- %s%nconstant: %s \t+- %s%narea    : %s \t+- %s\n", GaussFitting.getMean(), GaussFitting.getMeanError(), GaussFitting.getRMS(), GaussFitting.getRMSError(), GaussFitting.getConstant(), GaussFitting.getConstantError(), GaussFitting.getArea(), GaussFitting.getAreaError());
    }
}

