/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.ComplexPair;
import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public final class BandStopTransform {
    private BandStopTransform() {
    }

    public static void transform(double fc, double fw, LayoutBase digital, LayoutBase analog) {
        digital.reset();
        double ww = Math.PI * 2 * fw;
        double wc2 = Math.PI * 2 * fc - ww / 2.0;
        double wc = wc2 + ww;
        if (wc2 < 1.0E-8) {
            wc2 = 1.0E-8;
        }
        if (wc > 3.141592643589793) {
            wc = 3.141592643589793;
        }
        double a = Math.cos((wc + wc2) * 0.5) / Math.cos((wc - wc2) * 0.5);
        double b = Math.tan((wc - wc2) * 0.5);
        int numPoles = analog.getNumPoles();
        int pairs = numPoles / 2;
        for (int i = 0; i < pairs; ++i) {
            PoleZeroPair pair = analog.getPair(i);
            ComplexPair p = BandStopTransform.transform(pair.poles.first, a, b);
            ComplexPair z = BandStopTransform.transform(pair.zeros.first, a, b);
            digital.addPoleZeroConjugatePairs(p.first, z.first);
            digital.addPoleZeroConjugatePairs(p.second, z.second);
        }
        if ((numPoles & 1) == 1) {
            ComplexPair poles = BandStopTransform.transform(analog.getPair((int)pairs).poles.first, a, b);
            ComplexPair zeros = BandStopTransform.transform(analog.getPair((int)pairs).zeros.first, a, b);
            digital.add(poles, zeros);
        }
        if (fc < 0.25) {
            digital.setNormal(Math.PI, analog.getNormalGain());
        } else {
            digital.setNormal(0.0, analog.getNormalGain());
        }
    }

    private static ComplexPair transform(Complex in, double a, double b) {
        Complex c = in.isInfinite() ? new Complex(-1.0) : new Complex(1.0).add(in).divide(new Complex(1.0).subtract(in));
        double a2 = a * a;
        double b2 = b * b;
        Complex u = new Complex(0.0);
        u = u.add(c.multiply(4.0 * (b2 + a2 - 1.0)));
        u = u.add(8.0 * (b2 - a2 + 1.0));
        u = u.multiply(c);
        u = u.add(4.0 * (a2 + b2 - 1.0));
        u = u.sqrt();
        Complex v = u.multiply(-0.5).add(a);
        v = v.add(c.multiply(-a));
        u = u.multiply(0.5);
        u = u.add(a);
        u = u.add(c.multiply(-a));
        Complex d = new Complex(b + 1.0);
        d = d.add(c.multiply(b - 1.0));
        return new ComplexPair(u.divide(d), v.divide(d));
    }
}

