/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;

public class ListMetaBuilder
extends ListMetaFluentImpl<ListMetaBuilder>
implements VisitableBuilder<ListMeta, ListMetaBuilder> {
    ListMetaFluent<?> fluent;
    Boolean validationEnabled;

    public ListMetaBuilder() {
        this(true);
    }

    public ListMetaBuilder(Boolean validationEnabled) {
        this(new ListMeta(), validationEnabled);
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ListMeta(), validationEnabled);
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent, ListMeta instance) {
        this(fluent, instance, true);
    }

    public ListMetaBuilder(ListMetaFluent<?> fluent, ListMeta instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
        this.validationEnabled = validationEnabled;
    }

    public ListMetaBuilder(ListMeta instance) {
        this(instance, (Boolean)true);
    }

    public ListMetaBuilder(ListMeta instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.validationEnabled = validationEnabled;
    }

    public ListMeta build() {
        ListMeta buildable = new ListMeta(this.fluent.getResourceVersion(), this.fluent.getSelfLink());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListMetaBuilder that = (ListMetaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

