/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.openshift.api.model.NamedRoleBinding;
import io.fabric8.openshift.api.model.PolicyBinding;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractPolicyBindingAssert<S extends AbstractPolicyBindingAssert<S, A>, A extends PolicyBinding>
extends AbstractAssert<S, A> {
    protected AbstractPolicyBindingAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((PolicyBinding)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }

    public S hasApiVersion(PolicyBinding.ApiVersion apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        PolicyBinding.ApiVersion actualApiVersion = ((PolicyBinding)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)((Object)actualApiVersion), (Object)((Object)apiVersion))) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((PolicyBinding)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }

    public S hasLastModified(String lastModified) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lastModified of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualLastModified = ((PolicyBinding)this.actual).getLastModified();
        if (!Objects.areEqual((Object)actualLastModified, (Object)lastModified)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lastModified, actualLastModified});
        }
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }

    public S hasMetadata(ObjectMeta metadata) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ObjectMeta actualMetadata = ((PolicyBinding)this.actual).getMetadata();
        if (!Objects.areEqual((Object)actualMetadata, (Object)metadata)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metadata, actualMetadata});
        }
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }

    public S hasPolicyRef(ObjectReference policyRef) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting policyRef of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ObjectReference actualPolicyRef = ((PolicyBinding)this.actual).getPolicyRef();
        if (!Objects.areEqual((Object)actualPolicyRef, (Object)policyRef)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, policyRef, actualPolicyRef});
        }
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }

    public S hasRoleBindings(NamedRoleBinding ... roleBindings) {
        this.isNotNull();
        if (roleBindings == null) {
            this.failWithMessage("Expecting roleBindings parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PolicyBinding)this.actual).getRoleBindings(), (Object[])roleBindings);
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }

    public S hasOnlyRoleBindings(NamedRoleBinding ... roleBindings) {
        this.isNotNull();
        if (roleBindings == null) {
            this.failWithMessage("Expecting roleBindings parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((PolicyBinding)this.actual).getRoleBindings(), (Object[])roleBindings);
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }

    public S doesNotHaveRoleBindings(NamedRoleBinding ... roleBindings) {
        this.isNotNull();
        if (roleBindings == null) {
            this.failWithMessage("Expecting roleBindings parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((PolicyBinding)this.actual).getRoleBindings(), (Object[])roleBindings);
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }

    public S hasNoRoleBindings() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have roleBindings but had :\n  <%s>";
        if (((PolicyBinding)this.actual).getRoleBindings().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PolicyBinding)this.actual).getRoleBindings()});
        }
        return (S)((Object)((AbstractPolicyBindingAssert)this.myself));
    }
}

