/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.ComponentCondition;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractComponentStatusAssert<S extends AbstractComponentStatusAssert<S, A>, A extends ComponentStatus>
extends AbstractAssert<S, A> {
    protected AbstractComponentStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((ComponentStatus)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractComponentStatusAssert)this.myself));
    }

    public S hasApiVersion(ComponentStatus.ApiVersion apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ComponentStatus.ApiVersion actualApiVersion = ((ComponentStatus)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)((Object)actualApiVersion), (Object)((Object)apiVersion))) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractComponentStatusAssert)this.myself));
    }

    public S hasConditions(ComponentCondition ... conditions) {
        this.isNotNull();
        if (conditions == null) {
            this.failWithMessage("Expecting conditions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ComponentStatus)this.actual).getConditions(), (Object[])conditions);
        return (S)((Object)((AbstractComponentStatusAssert)this.myself));
    }

    public S hasOnlyConditions(ComponentCondition ... conditions) {
        this.isNotNull();
        if (conditions == null) {
            this.failWithMessage("Expecting conditions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((ComponentStatus)this.actual).getConditions(), (Object[])conditions);
        return (S)((Object)((AbstractComponentStatusAssert)this.myself));
    }

    public S doesNotHaveConditions(ComponentCondition ... conditions) {
        this.isNotNull();
        if (conditions == null) {
            this.failWithMessage("Expecting conditions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((ComponentStatus)this.actual).getConditions(), (Object[])conditions);
        return (S)((Object)((AbstractComponentStatusAssert)this.myself));
    }

    public S hasNoConditions() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have conditions but had :\n  <%s>";
        if (((ComponentStatus)this.actual).getConditions().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ComponentStatus)this.actual).getConditions()});
        }
        return (S)((Object)((AbstractComponentStatusAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((ComponentStatus)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractComponentStatusAssert)this.myself));
    }

    public S hasMetadata(ObjectMeta metadata) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ObjectMeta actualMetadata = ((ComponentStatus)this.actual).getMetadata();
        if (!Objects.areEqual((Object)actualMetadata, (Object)metadata)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metadata, actualMetadata});
        }
        return (S)((Object)((AbstractComponentStatusAssert)this.myself));
    }
}

