/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Transaction;
import io.delta.kernel.TransactionBuilder;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.TableFeatures;
import io.delta.kernel.internal.TableImpl;
import io.delta.kernel.internal.TransactionImpl;
import io.delta.kernel.internal.actions.Format;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.SnapshotHint;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.SchemaUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBuilderImpl
implements TransactionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TransactionBuilderImpl.class);
    private final long currentTimeMillis = System.currentTimeMillis();
    private final TableImpl table;
    private final String engineInfo;
    private final Operation operation;
    private Optional<StructType> schema = Optional.empty();
    private Optional<List<String>> partitionColumns = Optional.empty();
    private Optional<SetTransaction> setTxnOpt = Optional.empty();
    private Optional<Map<String, String>> tableProperties = Optional.empty();

    public TransactionBuilderImpl(TableImpl tableImpl, String string, Operation operation) {
        this.table = tableImpl;
        this.engineInfo = string;
        this.operation = operation;
    }

    @Override
    public TransactionBuilder withSchema(Engine engine, StructType structType) {
        this.schema = Optional.of(structType);
        return this;
    }

    @Override
    public TransactionBuilder withPartitionColumns(Engine engine, List<String> list) {
        if (!list.isEmpty()) {
            this.partitionColumns = Optional.of(list);
        }
        return this;
    }

    @Override
    public TransactionBuilder withTransactionId(Engine engine, String string, long l) {
        SetTransaction setTransaction = new SetTransaction(Objects.requireNonNull(string, "applicationId is null"), l, Optional.of(this.currentTimeMillis));
        this.setTxnOpt = Optional.of(setTransaction);
        return this;
    }

    @Override
    public TransactionBuilder withTableProperties(Engine engine, Map<String, String> map) {
        this.tableProperties = Optional.of(new HashMap<String, String>(map));
        return this;
    }

    @Override
    public Transaction build(Engine engine) {
        Object object;
        Object object2;
        SnapshotImpl snapshotImpl;
        try {
            snapshotImpl = (SnapshotImpl)this.table.getLatestSnapshot(engine);
        }
        catch (TableNotFoundException tableNotFoundException) {
            String string = this.table.getPath(engine);
            logger.info("Table {} doesn't exist yet. Trying to create a new table.", (Object)string);
            this.schema.orElseThrow(() -> DeltaErrors.requiresSchemaForNewTable(string));
            Metadata metadata = this.getInitialMetadata();
            object2 = this.getInitialProtocol();
            object = this.getEmptyLogReplay(engine, metadata, (Protocol)object2);
            snapshotImpl = new InitialSnapshot(this.table.getDataPath(), (LogReplay)object, metadata, (Protocol)object2);
        }
        boolean bl = snapshotImpl.getVersion(engine) < 0L;
        this.validate(engine, snapshotImpl, bl);
        boolean bl2 = false;
        boolean bl3 = false;
        object2 = snapshotImpl.getMetadata();
        object = snapshotImpl.getProtocol();
        if (this.tableProperties.isPresent()) {
            Set<String> set;
            Map<String, String> map = TableConfig.validateProperties(this.tableProperties.get());
            Map<String, String> map2 = ((Metadata)object2).filterOutUnchangedProperties(map);
            ColumnMapping.verifyColumnMappingChange(((Metadata)object2).getConfiguration(), map2, bl);
            if (!map2.isEmpty()) {
                bl2 = true;
                object2 = ((Metadata)object2).withNewConfiguration(map2);
            }
            if (!(set = TableFeatures.extractAutomaticallyEnabledWriterFeatures((Metadata)object2, (Protocol)object)).isEmpty()) {
                logger.info("Automatically enabling writer features: {}", set);
                bl3 = true;
                List<String> list = ((Protocol)object).getWriterFeatures();
                object = ((Protocol)object).withNewWriterFeatures(set);
                List<String> list2 = ((Protocol)object).getWriterFeatures();
                Preconditions.checkArgument(!Objects.equals(list, list2));
                TableFeatures.validateWriteSupportedTable((Protocol)object, (Metadata)object2, ((Metadata)object2).getSchema(), this.table.getPath(engine));
            }
        }
        return new TransactionImpl(bl, this.table.getDataPath(), this.table.getLogPath(), snapshotImpl, this.engineInfo, this.operation, (Protocol)object, (Metadata)object2, this.setTxnOpt, bl2, bl3, this.table.getClock());
    }

    private void validate(Engine engine, SnapshotImpl snapshotImpl, boolean bl) {
        String string = this.table.getPath(engine);
        TableFeatures.validateWriteSupportedTable(snapshotImpl.getProtocol(), snapshotImpl.getMetadata(), snapshotImpl.getMetadata().getSchema(), string);
        if (!bl) {
            if (this.schema.isPresent()) {
                throw DeltaErrors.tableAlreadyExists(string, "Table already exists, but provided a new schema. Schema can only be set on a new table.");
            }
            if (this.partitionColumns.isPresent()) {
                throw DeltaErrors.tableAlreadyExists(string, "Table already exists, but provided new partition columns. Partition columns can only be set on a new table.");
            }
        } else {
            ColumnMapping.ColumnMappingMode columnMappingMode = ColumnMapping.getColumnMappingMode(this.tableProperties.orElse(Collections.emptyMap()));
            SchemaUtils.validateSchema(this.schema.get(), ColumnMapping.isColumnMappingModeEnabled(columnMappingMode));
            SchemaUtils.validatePartitionColumns(this.schema.get(), this.partitionColumns.orElse(Collections.emptyList()));
        }
        this.setTxnOpt.ifPresent(setTransaction -> {
            Optional<Long> optional = snapshotImpl.getLatestTransactionVersion(engine, setTransaction.getAppId());
            if (optional.isPresent() && optional.get() >= setTransaction.getVersion()) {
                throw DeltaErrors.concurrentTransaction(setTransaction.getAppId(), setTransaction.getVersion(), optional.get());
            }
        });
    }

    private LogReplay getEmptyLogReplay(Engine engine, final Metadata metadata, final Protocol protocol) {
        return new LogReplay(this.table.getLogPath(), this.table.getDataPath(), -1L, engine, LogSegment.empty(this.table.getLogPath()), Optional.empty()){

            @Override
            protected Tuple2<Protocol, Metadata> loadTableProtocolAndMetadata(Engine engine, Optional<SnapshotHint> optional, long l) {
                return new Tuple2<Protocol, Metadata>(protocol, metadata);
            }

            @Override
            public Optional<Long> getLatestTransactionIdentifier(Engine engine, String string) {
                return Optional.empty();
            }
        };
    }

    private Metadata getInitialMetadata() {
        List<String> list = SchemaUtils.casePreservingPartitionColNames(this.schema.get(), this.partitionColumns.orElse(Collections.emptyList()));
        return new Metadata(UUID.randomUUID().toString(), Optional.empty(), Optional.empty(), new Format(), this.schema.get().toJson(), this.schema.get(), VectorUtils.stringArrayValue(list), Optional.of(this.currentTimeMillis), VectorUtils.stringStringMapValue(Collections.emptyMap()));
    }

    private Protocol getInitialProtocol() {
        return new Protocol(1, 2, null, null);
    }

    private class InitialSnapshot
    extends SnapshotImpl {
        InitialSnapshot(Path path, LogReplay logReplay, Metadata metadata, Protocol protocol) {
            super(path, LogSegment.empty(TransactionBuilderImpl.this.table.getLogPath()), logReplay, protocol, metadata);
        }

        @Override
        public long getTimestamp(Engine engine) {
            return -1L;
        }
    }
}

