/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.utils;

import java.util.NoSuchElementException;
import java.util.Objects;

public class Nullable<T> {
    private static final Nullable<?> EMPTY = new Nullable();
    private static final Nullable<?> NULL = new Nullable<Object>(null);
    private final T value;
    private boolean present;

    private Nullable() {
        this.value = null;
        this.present = false;
    }

    private Nullable(T value) {
        this.value = value;
        this.present = true;
    }

    public static <T> Nullable<T> empty() {
        return EMPTY;
    }

    public static <T> Nullable<T> of(T value) {
        return new Nullable<T>(value);
    }

    public static <T> Nullable<T> ofNullable(T value) {
        return value == null ? Nullable.empty() : Nullable.of(value);
    }

    public static <T> Nullable<T> nullValue() {
        return NULL;
    }

    public boolean isPresent() {
        return this.present;
    }

    public T get() {
        if (!this.present) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.present ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Nullable)) {
            return false;
        }
        Nullable other = (Nullable)obj;
        return Objects.equals(this.present, other.present) && Objects.equals(this.value, other.value);
    }
}

