/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository.foward.strategy;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.MultivaluedMap;
import io.crnk.core.engine.internal.utils.ResourceUtils;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.foward.strategy.ForwardingGetStrategy;
import io.crnk.core.repository.foward.strategy.ForwardingStrategyBase;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.DefaultResourceList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GetFromOwnerStrategy<T, I, D, J>
extends ForwardingStrategyBase
implements ForwardingGetStrategy<T, I, D, J> {
    @Override
    public MultivaluedMap<I, D> findTargets(Collection<I> sourceIds, String fieldName, QuerySpec querySpec, QueryContext queryContext) {
        RegistryEntry sourceEntry = this.context.getSourceEntry();
        ResourceInformation sourceInformation = sourceEntry.getResourceInformation();
        ResourceField field = sourceInformation.findFieldByUnderlyingName(fieldName);
        RegistryEntry targetEntry = this.context.getTargetEntry(field);
        List sources = (List)sourceEntry.getResourceRepository().findAll(sourceIds, this.context.createSaveQueryAdapter(fieldName, queryContext)).get().getEntity();
        ResourceInformation targetInformation = targetEntry.getResourceInformation();
        if (field.hasIdField()) {
            HashSet<Object> targetIds = new HashSet<Object>();
            for (Object source : sources) {
                Object targetId = field.getIdAccessor().getValue(source);
                if (targetId == null) continue;
                if (field.isCollection()) {
                    targetIds.addAll((Collection)targetId);
                    continue;
                }
                targetIds.add(targetId);
            }
            if (!targetIds.isEmpty()) {
                ResourceRepositoryAdapter targetAdapter = targetEntry.getResourceRepository();
                JsonApiResponse response = targetAdapter.findAll(targetIds, this.context.createQueryAdapter(querySpec, queryContext)).get();
                List targets = (List)response.getEntity();
                return this.toResult(field, targetInformation, sources, targets);
            }
            return this.newResultMap();
        }
        MultivaluedMap bulkResult = this.newResultMap();
        for (Object source : sources) {
            Object sourceId = sourceInformation.getId(source);
            Object target = field.getAccessor().getValue(source);
            if (target == null) continue;
            if (field.isCollection()) {
                bulkResult.addAll(sourceId, querySpec.apply((Collection)target));
                continue;
            }
            bulkResult.add(sourceId, target);
        }
        return bulkResult;
    }

    private MultivaluedMap newResultMap() {
        return new MultivaluedMap<I, D>(){

            @Override
            protected List<D> newList() {
                return new DefaultResourceList();
            }
        };
    }

    private MultivaluedMap<I, D> toResult(ResourceField field, ResourceInformation targetInformation, List sources, List<D> targets) {
        MultivaluedMap bulkResult = this.newResultMap();
        HashMap<Object, D> targetMap = new HashMap<Object, D>();
        for (D target : targets) {
            Object targetId = targetInformation.getId(target);
            targetMap.put(targetId, target);
        }
        for (Object source : sources) {
            Object sourceId = field.getResourceInformation().getId(source);
            Object targetId = field.getIdAccessor().getValue(source);
            if (field.isCollection()) {
                Collection targetIds = ResourceUtils.toTypedIds(targetInformation, (Collection)targetId);
                targetIds.retainAll(targetMap.keySet());
                for (Object targetElementId : targetIds) {
                    this.addResult(bulkResult, field, sourceId, targetElementId, targetMap);
                }
                continue;
            }
            if (targetId != null) {
                targetId = ResourceUtils.toTypedId(targetInformation, targetId);
                this.addResult(bulkResult, field, sourceId, targetId, targetMap);
                continue;
            }
            bulkResult.add(sourceId, null);
        }
        return bulkResult;
    }

    private void addResult(MultivaluedMap bulkResult, ResourceField field, Object sourceId, Object targetId, Map targetMap) {
        Object target = targetMap.get(targetId);
        if (target == null) {
            throw new ResourceNotFoundException("targetId=" + targetId + " not found for sourceId=" + sourceId + ", field=" + field.getUnderlyingName() + ", sourceType=" + field.getResourceInformation().getResourceType());
        }
        bulkResult.add(sourceId, target);
    }
}

