/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.exception.MethodNotAllowedException;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepository;
import io.crnk.core.resource.list.ResourceList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public abstract class ResourceRepositoryBase<T, I>
implements ResourceRepository<T, I>,
ResourceRegistryAware {
    private Class<T> resourceClass;
    private ResourceRegistry resourceRegistry;

    public ResourceRepositoryBase(Class<T> resourceClass) {
        this.resourceClass = resourceClass;
    }

    @Override
    public Class<T> getResourceClass() {
        return this.resourceClass;
    }

    @Override
    public T findOne(I id, QuerySpec querySpec) {
        RegistryEntry entry = this.resourceRegistry.findEntry(this.resourceClass);
        String idName = entry.getResourceInformation().getIdField().getUnderlyingName();
        QuerySpec idQuerySpec = querySpec.clone();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(idName), FilterOperator.EQ, id));
        ResourceList Collection2 = this.findAll(idQuerySpec);
        Iterator iterator = Collection2.iterator();
        if (iterator.hasNext()) {
            Object resource = iterator.next();
            PreconditionUtil.verify(!iterator.hasNext(), "expected unique result for id=%s, querySpec=%s", id, querySpec);
            return (T)resource;
        }
        throw new ResourceNotFoundException("resource not found: " + id);
    }

    @Override
    public ResourceList<T> findAll(Collection<I> ids, QuerySpec querySpec) {
        RegistryEntry entry = this.resourceRegistry.findEntry(this.resourceClass);
        String idName = entry.getResourceInformation().getIdField().getUnderlyingName();
        QuerySpec idQuerySpec = querySpec.clone();
        idQuerySpec.addFilter(new FilterSpec(Arrays.asList(idName), FilterOperator.EQ, ids));
        return this.findAll(idQuerySpec);
    }

    @Override
    public <S extends T> S save(S resource) {
        throw new MethodNotAllowedException("method not allowed");
    }

    @Override
    public <S extends T> S create(S resource) {
        return this.save(resource);
    }

    @Override
    public void delete(I id) {
        throw new MethodNotAllowedException("method not allowed");
    }

    @Override
    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }
}

