/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryBase;
import io.crnk.core.resource.list.ResourceList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryResourceRepository<T, I>
extends ResourceRepositoryBase<T, I> {
    protected Map<I, T> resources = new ConcurrentHashMap<I, T>();
    private ResourceRegistry resourceRegistry;

    public InMemoryResourceRepository(Class<T> resourceClass) {
        super(resourceClass);
    }

    public Map<I, T> getMap() {
        return this.resources;
    }

    public void clear() {
        this.resources.clear();
    }

    @Override
    public ResourceList<T> findAll(QuerySpec querySpec) {
        return querySpec.apply(this.resources.values());
    }

    @Override
    public <S extends T> S save(S entity) {
        RegistryEntry entry = this.resourceRegistry.findEntry(this.getResourceClass());
        ResourceField idField = entry.getResourceInformation().getIdField();
        Object id = idField.getAccessor().getValue(entity);
        PreconditionUtil.verify(id != null, "resource %s must have an identifier", this.resources);
        this.resources.put(id, entity);
        return entity;
    }

    @Override
    public void delete(I id) {
        this.resources.remove(id);
    }

    @Override
    public void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
        super.setResourceRegistry(resourceRegistry);
    }
}

