/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.repository;

import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.repository.Repository;
import io.crnk.core.repository.ResourceRepository;
import java.util.Arrays;
import java.util.List;

public interface BulkResourceRepository<T, I>
extends ResourceRepository<T, I>,
Repository {
    @Override
    default public <S extends T> S save(S resource) {
        List<Object> results = this.save(Arrays.asList(resource));
        PreconditionUtil.verifyEquals(1, results.size(), "expected single result", new Object[0]);
        return (S)results.get(0);
    }

    @Override
    default public <S extends T> S create(S resource) {
        List<Object> results = this.create(Arrays.asList(resource));
        PreconditionUtil.verifyEquals(1, results.size(), "expected single result", new Object[0]);
        return (S)results.get(0);
    }

    @Override
    default public void delete(I id) {
        this.delete(Arrays.asList(id));
    }

    @Override
    public <S extends T> List<S> save(List<S> var1);

    @Override
    public <S extends T> List<S> create(List<S> var1);

    @Override
    public void delete(List<I> var1);
}

