/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.pagingspec;

import io.crnk.core.exception.ParametersDeserializationException;
import io.crnk.core.queryspec.pagingspec.LimitBoundedPagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.resource.links.PagedLinksInformation;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.HasMoreResourcesMetaInformation;
import io.crnk.core.resource.meta.PagedMetaInformation;
import java.util.Set;

abstract class PagingBehaviorBase<T extends PagingSpec>
implements LimitBoundedPagingBehavior<T> {
    protected Long defaultLimit;
    protected Long maxPageLimit;

    PagingBehaviorBase() {
    }

    @Override
    public Long getDefaultLimit() {
        return this.defaultLimit;
    }

    @Override
    public void setDefaultLimit(Long defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    @Override
    public Long getMaxPageLimit() {
        return this.maxPageLimit;
    }

    @Override
    public void setMaxPageLimit(Long maxPageLimit) {
        this.maxPageLimit = maxPageLimit;
    }

    protected Long getTotalCount(ResourceList<?> resources) {
        PagedMetaInformation pagedMeta = resources.getMeta(PagedMetaInformation.class);
        if (pagedMeta != null) {
            return pagedMeta.getTotalResourceCount();
        }
        return null;
    }

    protected Boolean isNextPageAvailable(ResourceList<?> resources) {
        HasMoreResourcesMetaInformation pagedMeta = resources.getMeta(HasMoreResourcesMetaInformation.class);
        if (pagedMeta != null) {
            return pagedMeta.getHasMoreResources();
        }
        return null;
    }

    protected boolean hasPageLinks(PagedLinksInformation pagedLinksInformation) {
        return pagedLinksInformation.getFirst() != null || pagedLinksInformation.getLast() != null || pagedLinksInformation.getPrev() != null || pagedLinksInformation.getNext() != null;
    }

    protected Long getValue(String name, Set<String> values) {
        if (values.size() > 1) {
            throw new ParametersDeserializationException(name);
        }
        try {
            return Long.parseLong(values.iterator().next());
        }
        catch (RuntimeException e) {
            throw new ParametersDeserializationException(name);
        }
    }
}

