/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.pagingspec;

import io.crnk.core.engine.internal.utils.CompareUtils;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.queryspec.pagingspec.NumberSizePagingSpec;
import io.crnk.core.queryspec.pagingspec.PagingSpec;

public class OffsetLimitPagingSpec
implements PagingSpec {
    private Long limit = null;
    private Long offset = 0L;

    public OffsetLimitPagingSpec() {
    }

    public OffsetLimitPagingSpec(Long offset, Long limit) {
        this.offset = offset;
        this.limit = limit;
    }

    public Long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public OffsetLimitPagingSpec setLimit(Long limit) {
        this.limit = limit;
        return this;
    }

    public OffsetLimitPagingSpec setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public OffsetLimitPagingSpec clone() {
        return new OffsetLimitPagingSpec(this.offset, this.limit);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.limit == null ? 0 : this.limit.hashCode());
        result = 31 * result + Long.valueOf(this.offset).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OffsetLimitPagingSpec other = (OffsetLimitPagingSpec)obj;
        return CompareUtils.isEquals(this.limit, other.limit) && CompareUtils.isEquals(this.offset, other.offset);
    }

    public String toString() {
        return "OffsetLimitPagingSpec[" + (this.offset != null ? "offset=" + this.offset : "") + (this.limit != null ? ", limit=" + this.limit : "") + ']';
    }

    @Override
    public <T extends PagingSpec> T convert(Class<T> pagingSpecType) {
        if (pagingSpecType.isInstance(this)) {
            return (T)this;
        }
        if (pagingSpecType.equals(NumberSizePagingSpec.class)) {
            if (this.offset == 0L && this.limit == null) {
                return (T)new NumberSizePagingSpec(1, null);
            }
            if (this.offset == 0L) {
                return (T)new NumberSizePagingSpec(1, this.limit.intValue());
            }
            if (this.offset != 0L && this.limit == null) {
                throw new UnsupportedOperationException("cannot use page offset without page limit");
            }
            int number = (int)(this.offset / this.limit);
            if ((long)number * this.limit != this.offset) {
                throw new BadRequestException(String.format("offset=%s must be multiple of limit=%s to support page number/size conversion", this.offset, this.limit));
            }
            return (T)new NumberSizePagingSpec(1 + number, this.limit.intValue());
        }
        throw new UnsupportedOperationException("cannot converted to " + pagingSpecType);
    }
}

