/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.pagingspec;

import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.exception.ParametersDeserializationException;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingSpec;
import io.crnk.core.queryspec.pagingspec.PagingBehaviorBase;
import io.crnk.core.queryspec.pagingspec.PagingSpecUrlBuilder;
import io.crnk.core.resource.links.PagedLinksInformation;
import io.crnk.core.resource.list.ResourceList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OffsetLimitPagingBehavior
extends PagingBehaviorBase<OffsetLimitPagingSpec> {
    private static final String OFFSET_PARAMETER = "offset";
    private static final String LIMIT_PARAMETER = "limit";
    private long defaultOffset = 0L;

    @Override
    public Map<String, Set<String>> serialize(OffsetLimitPagingSpec pagingSpec, String resourceType) {
        HashMap<String, Set<String>> values = new HashMap<String, Set<String>>();
        if (pagingSpec.getOffset() != 0L) {
            values.put(String.format("page[%s]", OFFSET_PARAMETER), new HashSet<String>(Arrays.asList(Long.toString(pagingSpec.getOffset()))));
        }
        if (pagingSpec.getLimit() != null) {
            values.put(String.format("page[%s]", LIMIT_PARAMETER), new HashSet<String>(Arrays.asList(Long.toString(pagingSpec.getLimit()))));
        }
        return values;
    }

    @Override
    public OffsetLimitPagingSpec deserialize(Map<String, Set<String>> parameters) {
        OffsetLimitPagingSpec result = this.createDefaultPagingSpec();
        for (Map.Entry<String, Set<String>> param : parameters.entrySet()) {
            if (OFFSET_PARAMETER.equalsIgnoreCase(param.getKey())) {
                result.setOffset(this.getValue(param.getKey(), param.getValue()));
                continue;
            }
            if (LIMIT_PARAMETER.equalsIgnoreCase(param.getKey())) {
                Long limit = this.getValue(param.getKey(), param.getValue());
                if (this.maxPageLimit != null && limit != null && limit > this.maxPageLimit) {
                    throw new BadRequestException(String.format("%s value %d is larger than the maximum allowed of %d", LIMIT_PARAMETER, limit, this.maxPageLimit));
                }
                result.setLimit(limit);
                continue;
            }
            throw new ParametersDeserializationException(param.getKey());
        }
        return result;
    }

    @Override
    public OffsetLimitPagingSpec createEmptyPagingSpec() {
        return new OffsetLimitPagingSpec();
    }

    @Override
    public OffsetLimitPagingSpec createDefaultPagingSpec() {
        return new OffsetLimitPagingSpec(this.defaultOffset, this.defaultLimit);
    }

    @Override
    public void build(PagedLinksInformation linksInformation, ResourceList<?> resources, QueryAdapter queryAdapter, PagingSpecUrlBuilder urlBuilder) {
        Long totalCount = this.getTotalCount(resources);
        Boolean isNextPageAvailable = this.isNextPageAvailable(resources);
        if (!(totalCount == null && isNextPageAvailable == null || this.hasPageLinks(linksInformation))) {
            boolean hasResults = resources.iterator().hasNext();
            this.doEnrichPageLinksInformation(linksInformation, totalCount, isNextPageAvailable, queryAdapter, hasResults, urlBuilder);
        }
    }

    @Override
    public boolean isRequired(OffsetLimitPagingSpec pagingSpec) {
        return pagingSpec.getOffset() != 0L || pagingSpec.getLimit() != null;
    }

    private void doEnrichPageLinksInformation(PagedLinksInformation linksInformation, Long total, Boolean isNextPageAvailable, QueryAdapter queryAdapter, boolean hasResults, PagingSpecUrlBuilder urlBuilder) {
        OffsetLimitPagingSpec offsetLimitPagingSpec = (OffsetLimitPagingSpec)queryAdapter.getPagingSpec();
        long pageSize = offsetLimitPagingSpec.getLimit();
        long offset = offsetLimitPagingSpec.getOffset();
        long currentPage = offset / pageSize;
        if (currentPage * pageSize != offset) {
            throw new BadRequestException("offset " + offset + " is not a multiple of limit " + pageSize);
        }
        if (total != null) {
            isNextPageAvailable = offset + pageSize < total;
        }
        if (offset > 0L || hasResults) {
            Long totalPages = total != null ? Long.valueOf((total + pageSize - 1L) / pageSize) : null;
            QueryAdapter pageSpec = queryAdapter.duplicate();
            pageSpec.setPagingSpec(new OffsetLimitPagingSpec(0L, pageSize));
            linksInformation.setFirst(urlBuilder.build(pageSpec));
            if (totalPages != null && totalPages > 0L) {
                pageSpec.setPagingSpec(new OffsetLimitPagingSpec((totalPages - 1L) * pageSize, pageSize));
                linksInformation.setLast(urlBuilder.build(pageSpec));
            }
            if (currentPage > 0L) {
                pageSpec.setPagingSpec(new OffsetLimitPagingSpec((currentPage - 1L) * pageSize, pageSize));
                linksInformation.setPrev(urlBuilder.build(pageSpec));
            }
            if (isNextPageAvailable.booleanValue()) {
                pageSpec.setPagingSpec(new OffsetLimitPagingSpec((currentPage + 1L) * pageSize, pageSize));
                linksInformation.setNext(urlBuilder.build(pageSpec));
            }
        }
    }

    public long getDefaultOffset() {
        return this.defaultOffset;
    }

    public void setDefaultOffset(long defaultOffset) {
        this.defaultOffset = defaultOffset;
    }
}

