/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.mapper;

import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.queryspec.PathSpec;
import java.lang.reflect.Type;
import java.util.List;

public class QueryPathSpec {
    private Type valueType;
    private List<String> attributePath;
    private List<ResourceField> fields;

    public QueryPathSpec(Type valueType, List<String> attributePath, List<ResourceField> fields) {
        this.valueType = valueType;
        this.attributePath = attributePath;
        this.fields = fields;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public List<String> getAttributePath() {
        return this.attributePath;
    }

    public List<ResourceField> getFields() {
        return this.fields;
    }

    public void verifyFilterable() {
        if (this.fields != null) {
            for (ResourceField field : this.fields) {
                if (field == null || field.getAccess().isFilterable()) continue;
                throw new BadRequestException("path " + this.attributePath + " is not filterable");
            }
        }
    }

    public void verifySortable() {
        if (this.fields != null) {
            for (ResourceField field : this.fields) {
                if (field == null || field.getAccess().isSortable()) continue;
                throw new BadRequestException("path " + this.attributePath + " is not sortable");
            }
        }
    }

    public PathSpec toPathSpec() {
        return PathSpec.of(this.getAttributePath());
    }
}

