/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.parser.ParserException;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.ParametersDeserializationException;
import io.crnk.core.exception.RepositoryNotFoundException;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.queryspec.internal.DefaultQueryPathResolver;
import io.crnk.core.queryspec.internal.JsonFilterSpecMapper;
import io.crnk.core.queryspec.mapper.QueryParameter;
import io.crnk.core.queryspec.mapper.QueryParameterType;
import io.crnk.core.queryspec.mapper.QueryPathResolver;
import io.crnk.core.queryspec.mapper.QueryPathSpec;
import io.crnk.core.queryspec.mapper.QuerySpecUrlContext;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.UnkonwnMappingAware;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQuerySpecUrlMapper
implements QuerySpecUrlMapper,
UnkonwnMappingAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultQuerySpecUrlMapper.class);
    private static final String NULL_VALUE_STRING = "null";
    private FilterOperator defaultOperator = FilterOperator.EQ;
    private Map<String, FilterOperator> supportedOperators = new HashMap<String, FilterOperator>();
    private boolean enforceDotPathSeparator = true;
    private boolean ignoreParseExceptions;
    private boolean allowUnknownParameters = false;
    protected QuerySpecUrlContext context;
    protected QueryPathResolver pathResolver = new DefaultQueryPathResolver();
    private boolean allowCommaSeparatedValue = true;
    private JsonFilterSpecMapper jsonParser;
    private ObjectMapper compactMapper = new ObjectMapper();

    public DefaultQuerySpecUrlMapper() {
        this.addSupportedOperator(FilterOperator.LIKE);
        this.addSupportedOperator(FilterOperator.EQ);
        this.addSupportedOperator(FilterOperator.NEQ);
        this.addSupportedOperator(FilterOperator.NOT);
        this.addSupportedOperator(FilterOperator.AND);
        this.addSupportedOperator(FilterOperator.OR);
        this.addSupportedOperator(FilterOperator.GT);
        this.addSupportedOperator(FilterOperator.GE);
        this.addSupportedOperator(FilterOperator.LT);
        this.addSupportedOperator(FilterOperator.LE);
        this.addSupportedOperator(FilterOperator.SELECT);
        this.addSupportedOperator(FilterOperator.GROUP);
    }

    @Override
    public void init(QuerySpecUrlContext ctx) {
        this.context = ctx;
        this.pathResolver.init(this.context);
        this.jsonParser = new JsonFilterSpecMapper(ctx, this.supportedOperators, this.defaultOperator, this.pathResolver);
    }

    public boolean getEnforceDotPathSeparator() {
        return this.enforceDotPathSeparator;
    }

    public void setEnforceDotPathSeparator(boolean enforceDotPathSeparator) {
        this.enforceDotPathSeparator = enforceDotPathSeparator;
    }

    @Override
    public boolean getAllowUnknownAttributes() {
        return this.pathResolver.getAllowUnknownAttributes();
    }

    @Override
    public void setAllowUnknownAttributes(boolean allowUnknownAttributes) {
        this.pathResolver.setAllowUnknownAttributes(allowUnknownAttributes);
    }

    public boolean getAllowCommaSeparatedValue() {
        return this.allowCommaSeparatedValue;
    }

    public void setAllowCommaSeparatedValue(boolean allowCommaSeparatedValue) {
        this.allowCommaSeparatedValue = allowCommaSeparatedValue;
    }

    public boolean getMapJsonNames() {
        return this.pathResolver.getMapJsonNames();
    }

    public void setMapJsonNames(boolean mapJsonNames) {
        this.pathResolver.setMapJsonNames(mapJsonNames);
    }

    public FilterOperator getDefaultOperator() {
        return this.defaultOperator;
    }

    public void setDefaultOperator(FilterOperator defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    public Collection<FilterOperator> getSupportedOperators() {
        return this.supportedOperators.values();
    }

    public void addSupportedOperator(FilterOperator supportedOperator) {
        this.supportedOperators.put(supportedOperator.getName(), supportedOperator);
    }

    protected QuerySpec createQuerySpec(ResourceInformation resourceInformation) {
        return new QuerySpec(resourceInformation);
    }

    @Override
    public QuerySpec deserialize(ResourceInformation resourceInformation, Map<String, Set<String>> parameterMap, QueryContext queryContext) {
        QuerySpec rootQuerySpec = this.createQuerySpec(resourceInformation);
        List<QueryParameter> parameters = this.parseParameters(parameterMap, resourceInformation);
        HashMap<String, Set<String>> pageParameters = new HashMap<String, Set<String>>();
        block8: for (QueryParameter parameter : parameters) {
            QuerySpec querySpec = rootQuerySpec;
            if (parameter.getResourceInformation() != null && (querySpec = rootQuerySpec.getQuerySpec(parameter.getResourceInformation())) == null) {
                querySpec = rootQuerySpec.getOrCreateQuerySpec(parameter.getResourceInformation());
            }
            switch (parameter.getType()) {
                case SORT: {
                    this.deserializeSort(querySpec, parameter, queryContext);
                    continue block8;
                }
                case FILTER: {
                    this.deserializeFilter(querySpec, parameter, queryContext);
                    continue block8;
                }
                case INCLUDE: {
                    this.deserializeIncludes(querySpec, parameter, queryContext);
                    continue block8;
                }
                case FIELDS: {
                    this.deserializeFields(querySpec, parameter, queryContext);
                    continue block8;
                }
                case VERSION: {
                    continue block8;
                }
                case PAGE: {
                    pageParameters.put(parameter.getPagingType(), parameter.getValues());
                    continue block8;
                }
            }
            this.deserializeUnknown(querySpec, parameter);
        }
        RegistryEntry entry = this.context.getResourceRegistry().getEntry(resourceInformation.getResourceType());
        PagingBehavior pagingBehavior = entry.getPagingBehavior();
        if (pagingBehavior == null && !pageParameters.isEmpty()) {
            throw new IllegalStateException("Instance of PagingBehavior must be provided");
        }
        if (pagingBehavior != null) {
            Object pagingSpec = pagingBehavior.deserialize(pageParameters);
            rootQuerySpec.setPaging((PagingSpec)pagingSpec);
        }
        return rootQuerySpec;
    }

    private static void put(Map<String, Set<String>> map, String key, String value) {
        map.put(key, new HashSet<String>(Arrays.asList(value)));
    }

    private String toJsonPath(ResourceInformation resourceInformation, List<String> attributePath, QueryContext queryContext) {
        QueryPathSpec pathSpec = this.pathResolver.resolve(resourceInformation, attributePath, QueryPathResolver.NamingType.JAVA, null, queryContext);
        return StringUtils.join(".", pathSpec.getAttributePath());
    }

    protected String addResourceType(QueryParameterType type, String key, ResourceInformation resourceInformation, boolean isRoot) {
        String resourceType = resourceInformation.getResourceType();
        if (isRoot) {
            return type.toString().toLowerCase() + (key != null ? key : "");
        }
        return type.toString().toLowerCase() + "[" + resourceType + "]" + (key != null ? key : "");
    }

    protected String serializeValue(Object value) {
        if (value == null) {
            return NULL_VALUE_STRING;
        }
        TypeParser typeParser = this.context.getTypeParser();
        String strValue = typeParser.toString(value);
        PreconditionUtil.verify(strValue != null, "should not map to null: %s", value);
        return strValue;
    }

    @Override
    public Map<String, Set<String>> serialize(QuerySpec querySpec, QueryContext queryContext) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        this.serialize(querySpec, map, querySpec, queryContext);
        return map;
    }

    protected void serialize(QuerySpec querySpec, Map<String, Set<String>> map, QuerySpec rootQuerySpec, QueryContext queryContext) {
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        if (querySpec != null) {
            ResourceInformation resourceInformation;
            RegistryEntry entry;
            String resourceType = querySpec.getResourceType();
            if (resourceType == null) {
                entry = resourceRegistry.getEntry(querySpec.getResourceClass());
                if (entry == null) {
                    throw new RepositoryNotFoundException(querySpec.getResourceClass());
                }
                resourceInformation = entry.getResourceInformation();
            } else if (resourceRegistry.hasEntry(querySpec.getResourceType())) {
                entry = resourceRegistry.getEntry(querySpec.getResourceType());
                resourceInformation = entry.getResourceInformation();
            } else {
                resourceInformation = null;
            }
            boolean isRoot = querySpec == rootQuerySpec;
            this.serializeFilters(querySpec, resourceInformation, map, isRoot, queryContext);
            this.serializeSorting(querySpec, resourceInformation, map, isRoot, queryContext);
            this.serializeIncludedFields(querySpec, resourceInformation, map, isRoot, queryContext);
            this.serializeIncludedRelations(querySpec, resourceInformation, map, isRoot, queryContext);
            RegistryEntry rootEntry = resourceRegistry.getEntry(rootQuerySpec.getResourceClass());
            if (rootEntry != null && rootEntry.getResourceInformation() != null && rootEntry.getResourceInformation().getPagingSpecType() != null) {
                PagingBehavior pagingBehavior = rootEntry.getPagingBehavior();
                PagingSpec pagingSpec = pagingBehavior.createDefaultPagingSpec().getClass().isInstance(querySpec.getPaging()) ? querySpec.getPaging() : querySpec.getPaging(rootEntry.getResourceInformation().getPagingSpecType());
                map.putAll(pagingBehavior.serialize(pagingSpec, resourceType));
            }
            for (QuerySpec relatedSpec : querySpec.getNestedSpecs()) {
                this.serialize(relatedSpec, map, querySpec, queryContext);
            }
        }
    }

    protected void serializeFilters(QuerySpec querySpec, ResourceInformation resourceInformation, Map<String, Set<String>> map, boolean isRoot, QueryContext queryContext) {
        if (this.jsonParser.isNested(querySpec.getFilters())) {
            String json;
            JsonNode jsonNode = this.jsonParser.serialize(resourceInformation, querySpec.getFilters(), queryContext);
            try {
                json = this.compactMapper.writeValueAsString((Object)jsonNode);
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e);
            }
            String key = this.addResourceType(QueryParameterType.FILTER, null, resourceInformation, isRoot);
            DefaultQuerySpecUrlMapper.put(map, key, json);
        } else {
            for (FilterSpec filterSpec : querySpec.getFilters()) {
                String key;
                if (filterSpec.hasExpressions()) {
                    throw new UnsupportedOperationException("filter expressions like and and or not yet supported");
                }
                if (filterSpec.getAttributePath() != null) {
                    String attrKey = "[" + this.toJsonPath(resourceInformation, filterSpec.getAttributePath(), queryContext) + "]";
                    if (!this.defaultOperator.equals(filterSpec.getOperator())) {
                        attrKey = attrKey + "[" + filterSpec.getOperator().getName() + "]";
                    }
                    key = this.addResourceType(QueryParameterType.FILTER, attrKey, resourceInformation, isRoot);
                } else {
                    key = QueryParameterType.FILTER.toString().toLowerCase();
                }
                if (filterSpec.getValue() instanceof Collection) {
                    Collection col = (Collection)filterSpec.getValue();
                    HashSet<String> values = new HashSet<String>();
                    for (Object elem : col) {
                        values.add(this.serializeValue(elem));
                    }
                    if (this.allowCommaSeparatedValue) {
                        String strValue = values.stream().sorted().collect(Collectors.joining(","));
                        HashSet<String> singletonSet = new HashSet<String>();
                        singletonSet.add(strValue);
                        map.put(key, singletonSet);
                        continue;
                    }
                    map.put(key, values);
                    continue;
                }
                String value = this.serializeValue(filterSpec.getValue());
                DefaultQuerySpecUrlMapper.put(map, key, value);
            }
        }
    }

    public void serializeSorting(QuerySpec querySpec, ResourceInformation resourceInformation, Map<String, Set<String>> map, boolean isRoot, QueryContext queryContext) {
        if (!querySpec.getSort().isEmpty()) {
            String key = this.addResourceType(QueryParameterType.SORT, null, resourceInformation, isRoot);
            StringBuilder builder = new StringBuilder();
            for (SortSpec filterSpec : querySpec.getSort()) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                if (filterSpec.getDirection() == Direction.DESC) {
                    builder.append("-");
                }
                builder.append(this.toJsonPath(resourceInformation, filterSpec.getAttributePath(), queryContext));
            }
            DefaultQuerySpecUrlMapper.put(map, key, builder.toString());
        }
    }

    protected void serializeIncludedFields(QuerySpec querySpec, ResourceInformation resourceInformation, Map<String, Set<String>> map, boolean isRoot, QueryContext queryContext) {
        if (!querySpec.getIncludedFields().isEmpty()) {
            String key = this.addResourceType(QueryParameterType.FIELDS, null, resourceInformation, isRoot);
            StringBuilder builder = new StringBuilder();
            for (IncludeFieldSpec includedField : querySpec.getIncludedFields()) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(this.toJsonPath(resourceInformation, includedField.getAttributePath(), queryContext));
            }
            DefaultQuerySpecUrlMapper.put(map, key, builder.toString());
        }
    }

    protected void serializeIncludedRelations(QuerySpec querySpec, ResourceInformation resourceInformation, Map<String, Set<String>> map, boolean isRoot, QueryContext queryContext) {
        if (!querySpec.getIncludedRelations().isEmpty()) {
            String key = this.addResourceType(QueryParameterType.INCLUDE, null, resourceInformation, isRoot);
            StringBuilder builder = new StringBuilder();
            for (IncludeRelationSpec includedField : querySpec.getIncludedRelations()) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(this.toJsonPath(resourceInformation, includedField.getAttributePath(), queryContext));
            }
            DefaultQuerySpecUrlMapper.put(map, key, builder.toString());
        }
    }

    protected void deserializeIncludes(QuerySpec querySpec, QueryParameter parameter, QueryContext queryContext) {
        for (String values : parameter.getValues()) {
            for (String value : this.splitValues(values)) {
                List<String> attributePath = this.splitAttributePath(value, parameter);
                ResourceInformation resourceInformation = parameter.getResourceInformation();
                QueryPathSpec resolvedPath = this.pathResolver.resolve(resourceInformation, attributePath, QueryPathResolver.NamingType.JSON, parameter.getName(), queryContext);
                querySpec.includeRelation(resolvedPath.getAttributePath());
            }
        }
    }

    private String[] splitValues(String values) {
        return values.split(",");
    }

    protected void deserializeFields(QuerySpec querySpec, QueryParameter parameter, QueryContext queryContext) {
        ResourceInformation resourceInformation = parameter.getResourceInformation();
        for (String values : parameter.getValues()) {
            for (String value : this.splitValues(values)) {
                List<String> attributePath = this.splitAttributePath(value, parameter);
                QueryPathSpec resolvedPath = this.pathResolver.resolve(resourceInformation, attributePath, QueryPathResolver.NamingType.JSON, parameter.getName(), queryContext);
                querySpec.includeField(resolvedPath.getAttributePath());
            }
        }
    }

    protected void deserializeFilter(QuerySpec querySpec, QueryParameter parameter, QueryContext queryContext) {
        ResourceInformation resourceInformation = parameter.getResourceInformation();
        FilterOperator operator = parameter.getOperator();
        QueryPathSpec resolvedPath = this.pathResolver.resolve(resourceInformation, parameter.getAttributePath(), QueryPathResolver.NamingType.JSON, parameter.getName(), queryContext);
        resolvedPath.verifyFilterable();
        Class<?> filterType = ClassUtils.getRawType(operator.getFilterType(parameter, resolvedPath.getValueType()));
        Optional<JsonNode> optional = this.getJsonQuery(resolvedPath, parameter);
        if (optional.isPresent()) {
            List<FilterSpec> filterSpecs = this.jsonParser.deserialize(optional.get(), parameter.getResourceInformation(), queryContext);
            filterSpecs.forEach(querySpec::addFilter);
        } else {
            HashSet<Object> typedValues = new HashSet<Object>();
            for (String stringValue : parameter.getValues()) {
                if (operator != FilterOperator.GROUP) {
                    typedValues.add(this.toObjectValue(stringValue, parameter, filterType));
                    continue;
                }
                typedValues.add(stringValue);
            }
            HashSet<Object> value = typedValues.size() == 1 ? typedValues.iterator().next() : typedValues;
            FilterSpec filterSpec = new FilterSpec(resolvedPath.getAttributePath(), operator, value);
            querySpec.addFilter(filterSpec);
        }
    }

    private Optional<JsonNode> getJsonQuery(QueryPathSpec resolvedPath, QueryParameter parameter) {
        String value;
        if (resolvedPath.getAttributePath() == null && parameter.getValues().size() == 1 && this.jsonParser.isJson(value = parameter.getValues().iterator().next())) {
            ObjectMapper objectMapper = this.context.getObjectMapper();
            try {
                return Optional.of(objectMapper.readTree(value));
            }
            catch (IOException e) {
                throw new ParametersDeserializationException("failed to parse " + value, e);
            }
        }
        return Optional.empty();
    }

    private Object toObjectValue(String stringValue, QueryParameter parameter, Class filterType) {
        try {
            if (NULL_VALUE_STRING.equals(stringValue)) {
                return null;
            }
            if (filterType != Object.class) {
                TypeParser typeParser = this.context.getTypeParser();
                return typeParser.parse(stringValue, filterType);
            }
            return stringValue;
        }
        catch (ParserException e) {
            if (this.ignoreParseExceptions) {
                LOGGER.debug("failed to parse {}", (Object)parameter);
                return stringValue;
            }
            throw new ParametersDeserializationException(parameter.toString(), e);
        }
    }

    private void deserializeSort(QuerySpec querySpec, QueryParameter parameter, QueryContext queryContext) {
        ResourceInformation resourceInformation = parameter.getResourceInformation();
        for (String values : parameter.getValues()) {
            for (String value : this.splitValues(values)) {
                boolean desc = value.startsWith("-");
                if (desc) {
                    value = value.substring(1);
                }
                List<String> attributePath = this.splitAttributePath(value, parameter);
                QueryPathSpec resolvedPath = this.pathResolver.resolve(resourceInformation, attributePath, QueryPathResolver.NamingType.JSON, parameter.getName(), queryContext);
                resolvedPath.verifySortable();
                Direction dir = desc ? Direction.DESC : Direction.ASC;
                querySpec.addSort(new SortSpec(resolvedPath.getAttributePath(), dir));
            }
        }
    }

    protected void deserializeUnknown(QuerySpec querySpec, QueryParameter parameter) {
        if (!this.allowUnknownParameters && !this.context.getUrlBuilder().getPropagatedParameters().contains(parameter.getName())) {
            throw new ParametersDeserializationException(parameter.getName());
        }
    }

    protected List<QueryParameter> parseParameters(Map<String, Set<String>> params, ResourceInformation rootResourceInformation) {
        ArrayList<QueryParameter> list = new ArrayList<QueryParameter>();
        Set<Map.Entry<String, Set<String>>> entrySet = params.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            list.add(this.parseParameter(entry.getKey(), entry.getValue(), rootResourceInformation));
        }
        return list;
    }

    protected QueryParameter parseParameter(String parameterName, Set<String> values, ResourceInformation rootResourceInformation) {
        String value;
        QueryParameterType paramType;
        int typeSep = parameterName.indexOf(91);
        String strParamType = typeSep != -1 ? parameterName.substring(0, typeSep) : parameterName;
        try {
            paramType = QueryParameterType.valueOf(strParamType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            paramType = QueryParameterType.UNKNOWN;
        }
        boolean jsonFilter = false;
        if (this.allowCommaSeparatedValue && paramType == QueryParameterType.FILTER && values.size() == 1 && !(jsonFilter = this.jsonParser.isJson(value = values.iterator().next()))) {
            String[] valueArray = value.split("\\,");
            values = new HashSet<String>(Arrays.asList(valueArray));
        }
        List<String> elements = this.parseParameterNameArguments(parameterName, typeSep);
        QueryParameter param = new QueryParameter(this.context.getTypeParser());
        param.setName(parameterName);
        param.setType(paramType);
        param.setValues(values);
        if (paramType == QueryParameterType.FILTER && elements.size() >= 1) {
            this.parseFilterParameterName(param, elements, rootResourceInformation, !jsonFilter);
        } else if (paramType == QueryParameterType.PAGE && elements.size() == 1) {
            param.setResourceInformation(rootResourceInformation);
            param.setPagingType(elements.get(0));
        } else if (paramType == QueryParameterType.PAGE && elements.size() == 2) {
            param.setResourceInformation(this.getResourceInformation(elements.get(0), parameterName));
            param.setPagingType(elements.get(1));
        } else if (paramType == QueryParameterType.UNKNOWN) {
            param.setResourceInformation(null);
        } else if (elements.size() == 1) {
            param.setResourceInformation(this.getResourceInformation(elements.get(0), parameterName));
        } else {
            param.setResourceInformation(rootResourceInformation);
        }
        if (param.getOperator() == null) {
            param.setOperator(this.defaultOperator);
        }
        return param;
    }

    protected List<String> parseParameterNameArguments(String parameterName, int typeSep) {
        ArrayList<String> elements = new ArrayList<String>();
        if (typeSep != -1) {
            String parameterNameSuffix = parameterName.substring(typeSep);
            if (!parameterNameSuffix.startsWith("[") || !parameterNameSuffix.endsWith("]")) {
                throw new ParametersDeserializationException("expected not [ resp. ] in legacy " + parameterName);
            }
            elements.addAll(Arrays.asList(parameterNameSuffix.substring(1, parameterNameSuffix.length() - 1).split("\\]\\[")));
        }
        return elements;
    }

    protected void parseFilterParameterName(QueryParameter param, List<String> elements, ResourceInformation rootResourceInformation, boolean canHaveAttributes) {
        this.parseFilterOperator(param, elements);
        if (elements.isEmpty()) {
            throw new ParametersDeserializationException("failed to parse " + param.getName() + ", expected ([resourceType])[attr1.attr2]([operator])");
        }
        if (this.enforceDotPathSeparator && elements.size() > 2) {
            throw new ParametersDeserializationException("failed to parse " + param.getName() + ", expected ([resourceType])[attr1.attr2]([operator])");
        }
        if (this.enforceDotPathSeparator && elements.size() == 2) {
            param.setResourceInformation(this.getResourceInformation(elements.get(0), param.getName()));
            param.setAttributePath(Arrays.asList(elements.get(1).split("\\.")));
        } else if (this.enforceDotPathSeparator && elements.size() == 1 && !canHaveAttributes) {
            param.setResourceInformation(this.getResourceInformation(elements.get(0), param.getName()));
        } else if (this.enforceDotPathSeparator && elements.size() == 1) {
            param.setResourceInformation(rootResourceInformation);
            param.setAttributePath(Arrays.asList(elements.get(0).split("\\.")));
        } else {
            this.legacyParseFilterParameterName(param, elements, rootResourceInformation);
        }
    }

    protected void legacyParseFilterParameterName(QueryParameter param, List<String> elements, ResourceInformation rootResourceInformation) {
        if (this.isResourceType(elements.get(0))) {
            param.setResourceInformation(this.getResourceInformation(elements.get(0), param.getName()));
            elements.remove(0);
        } else {
            param.setResourceInformation(rootResourceInformation);
        }
        ArrayList<String> attributePath = new ArrayList<String>();
        for (String element : elements) {
            attributePath.addAll(Arrays.asList(element.split("\\.")));
        }
        param.setAttributePath(attributePath);
    }

    protected void parseFilterOperator(QueryParameter param, List<String> elements) {
        String lastElement = elements.get(elements.size() - 1);
        FilterOperator operator = this.findOperator(lastElement);
        if (operator != null) {
            elements.remove(elements.size() - 1);
        } else {
            operator = this.defaultOperator;
        }
        param.setOperator(operator);
    }

    protected boolean isResourceType(String resourceType) {
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        return resourceRegistry.hasEntry(resourceType);
    }

    protected FilterOperator findOperator(String lastElement) {
        for (FilterOperator op : this.supportedOperators.values()) {
            if (!op.getName().equalsIgnoreCase(lastElement)) continue;
            return op;
        }
        return null;
    }

    protected ResourceInformation getResourceInformation(String resourceType, String parameterName) {
        ResourceRegistry resourceRegistry = this.context.getResourceRegistry();
        RegistryEntry registryEntry = resourceRegistry.getEntry(resourceType);
        if (registryEntry == null) {
            throw new ParametersDeserializationException("failed to parse parameter " + parameterName + ", resourceType=" + resourceType + " not found");
        }
        return registryEntry.getResourceInformation();
    }

    protected List<String> splitAttributePath(String pathString, QueryParameter param) {
        return Arrays.asList(pathString.split("\\."));
    }

    public boolean isIgnoreParseExceptions() {
        return this.ignoreParseExceptions;
    }

    public void setIgnoreParseExceptions(boolean ignoreParseExceptions) {
        this.ignoreParseExceptions = ignoreParseExceptions;
    }

    @Override
    public boolean isAllowUnknownParameters() {
        return this.allowUnknownParameters;
    }

    @Override
    public void setAllowUnknownParameters(boolean allowUnknownParameters) {
        this.allowUnknownParameters = allowUnknownParameters;
    }

    public boolean getAllowUnknownParameters() {
        return this.allowUnknownParameters;
    }

    public QueryPathResolver getPathResolver() {
        return this.pathResolver;
    }
}

